/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pregenerator.ChunkPregenerator;

public class RetrogenManager {
    public static final RetrogenManager INSTANCE = new RetrogenManager();
    Set<ResourceLocation> activeFeatures = new ObjectLinkedOpenHashSet();

    public Set<ResourceLocation> getInactiveFeatures(RegistryAccess access) {
        ObjectLinkedOpenHashSet locations = new ObjectLinkedOpenHashSet(this.getAllFeatures(access));
        locations.removeAll(this.activeFeatures);
        return locations;
    }

    public List<ResourceLocation> getAllFeatures(RegistryAccess access) {
        return new ObjectArrayList((Collection)access.m_6632_(Registry.f_122881_).map(Registry::m_6566_).orElse(Collections.emptySet()));
    }

    public Set<ResourceLocation> getActiveFeatures() {
        return new ObjectLinkedOpenHashSet(this.activeFeatures);
    }

    public void enableFeature(ResourceLocation location) {
        this.activeFeatures.add(location);
    }

    public void disableFeature(ResourceLocation location) {
        this.activeFeatures.remove(location);
    }

    public boolean isActive(ResourceLocation location) {
        return this.activeFeatures.contains(location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onSyncPacket(Set<ResourceLocation> active) {
        this.activeFeatures.clear();
        this.activeFeatures.addAll(active);
    }

    public void retrogenChunks(LevelChunk chunk, List<ChunkAccess> chunks) {
        if (this.activeFeatures.isEmpty()) {
            return;
        }
        BlockPos pos = chunk.m_7697_().m_45615_().m_142082_(8, 8, 8);
        int x = pos.m_123341_() - 8;
        int z = pos.m_123343_() - 8;
        try {
            ServerLevel world = (ServerLevel)chunk.m_62953_();
            WorldgenRandom sharedseedrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
            long i1 = sharedseedrandom.m_64690_(world.m_7328_(), x, z);
            ChunkGenerator generator = world.m_7726_().m_8481_();
            WorldGenRegion region = new WorldGenRegion(world, chunks, ChunkStatus.f_62326_, 8);
            Biome biome = (Biome)chunk.m_203495_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).m_203334_();
            for (GenerationStep.Decoration generationstage$decoration : GenerationStep.Decoration.values()) {
                try {
                    this.decorate(biome, generationstage$decoration, generator, (WorldGenLevel)region, i1, sharedseedrandom, pos);
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Biome decoration");
                    crashreport.m_127514_("Generation").m_128159_("CenterX", (Object)chunk.m_7697_().f_45578_).m_128159_("CenterZ", (Object)chunk.m_7697_().f_45579_).m_128159_("Step", (Object)generationstage$decoration).m_128159_("Seed", (Object)i1).m_128159_("Biome", (Object)ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)).m_128159_("Chunk Pregenerator Gen", (Object)true);
                    throw new ReportedException(crashreport);
                }
            }
        }
        catch (Exception e) {
            ChunkPregenerator.LOGGER.catching((Throwable)e);
        }
    }

    private void decorate(Biome biome, GenerationStep.Decoration stage, ChunkGenerator chunkGenerator, WorldGenLevel worldIn, long seed, WorldgenRandom random, BlockPos pos) {
        int i = 0;
        for (Holder feature : (HolderSet)biome.m_47536_().m_47818_().get(stage.ordinal())) {
            PlacedFeature configuredfeature = (PlacedFeature)feature.m_203334_();
            if (!this.activeFeatures.contains(BuiltinRegistries.f_123861_.m_7981_((Object)((ConfiguredFeature)configuredfeature.f_191775_().m_203334_())))) {
                ++i;
                continue;
            }
            random.m_190064_(seed, i, stage.ordinal());
            try {
                configuredfeature.m_191806_(worldIn, chunkGenerator, (Random)random, pos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)exception, (String)"Feature placement");
                crashreport.m_127514_("Feature").m_128159_("Id", (Object)BuiltinRegistries.f_123861_.m_7981_((Object)((ConfiguredFeature)configuredfeature.f_191775_().m_203334_())));
                throw new ReportedException(crashreport);
            }
            ++i;
        }
    }
}

