/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class CircleAreaTask
extends BaseTask {
    long min;
    long max;
    long center;

    public CircleAreaTask(String name, ResourceKey<Level> type, int genType, ChunkPos min, ChunkPos max) {
        super(name, type, genType);
        this.min = min.m_45588_();
        this.max = max.m_45588_();
        this.center = ChunkPos.m_45589_((int)(min.f_45578_ + (max.f_45578_ - min.f_45578_) / 2), (int)(min.f_45579_ + (max.f_45579_ - min.f_45579_) / 2));
    }

    public CircleAreaTask(CompoundTag nbt) {
        super(nbt);
        this.min = nbt.m_128454_("min");
        this.max = nbt.m_128454_("max");
        this.center = nbt.m_128454_("center");
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = super.write();
        tag.m_128356_("min", this.min);
        tag.m_128356_("max", this.max);
        tag.m_128356_("center", this.center);
        return tag;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return Math.max((ChunkPos.m_45592_((long)this.max) - ChunkPos.m_45592_((long)this.min)) / 2, (ChunkPos.m_45602_((long)this.max) - ChunkPos.m_45602_((long)this.min)) / 2);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public String getShapeName() {
        return "Circle Area";
    }

    @Override
    public long getTaskSize() {
        long x = ChunkPos.m_45592_((long)this.max) - ChunkPos.m_45592_((long)this.min);
        long z = ChunkPos.m_45602_((long)this.max) - ChunkPos.m_45602_((long)this.min);
        return (long)((double)(x * z) * Math.PI);
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        ITask.convert("Type=Circle Area, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("From [X=" + min.f_45578_ + ", Z=" + min.f_45579_ + "]", builder, ChatFormatting.YELLOW);
        ITask.convert("To [X=" + max.f_45578_ + ", Z=" + max.f_45579_ + "]", builder, ChatFormatting.YELLOW);
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos min = new ChunkPos(this.min);
        ChunkPos max = new ChunkPos(this.max);
        process.init(ChunkShapeBuilder.genCircleArea(min.f_45578_, min.f_45579_, max.f_45578_, max.f_45579_, progress), new ChunkPos(this.center), this.name, this.task, this.throwEvents, progress);
        return process;
    }
}

