/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class SquareExpansionTask
extends BaseTask {
    long center;
    int minRadius;
    int maxRadius;

    public SquareExpansionTask(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.minRadius = nbt.m_128451_("min_radius");
        this.maxRadius = nbt.m_128451_("max_radius");
    }

    public SquareExpansionTask(String name, ResourceKey<Level> type, int genType, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type, genType);
        this.center = center.m_45588_();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128356_("center", this.center);
        nbt.m_128405_("min_radius", this.minRadius);
        nbt.m_128405_("max_radius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public String getShapeName() {
        return "Square_Expansion";
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.convert("Type=Square Expansion, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("X=" + center.f_45578_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Z=" + center.f_45579_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.minRadius + ", ", builder, ChatFormatting.BLUE);
        ITask.convert("MaxRadius=" + this.maxRadius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        long minDiameter = (long)this.minRadius * 2L;
        long maxDiameter = (long)this.maxRadius * 2L;
        return maxDiameter * maxDiameter - minDiameter * minDiameter;
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        long diameter = (long)this.maxRadius * 2L;
        progress.setMax(diameter * diameter);
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getSquareExspansionShape(center.f_45578_, center.f_45579_, this.minRadius, this.maxRadius, progress), center, this.name, this.task, this.throwEvents, progress);
        return process;
    }
}

