/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.dimrequests.DimensionInfoAnswer;
import pregenerator.common.networking.dimrequests.DimensionInfoRequest;
import pregenerator.common.networking.processing.ProcessorInfoAnswer;
import pregenerator.common.networking.processing.ProcessorInfoRequest;
import pregenerator.common.networking.retrogen.RetrogenChangeAnswer;
import pregenerator.common.networking.retrogen.RetrogenChangeRequest;
import pregenerator.common.networking.retrogen.RetrogenSyncAnswer;
import pregenerator.common.networking.retrogen.RetrogenSyncRequest;

public class NetworkManager {
    public static final NetworkManager INSTANCE = new NetworkManager();
    SimpleChannel channel;

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chunkpregen", "networking"), () -> "default", T -> true, T -> true);
        this.registerPacket(1, ProcessorInfoRequest.class, ProcessorInfoRequest::new);
        this.registerPacket(2, ProcessorInfoAnswer.class, ProcessorInfoAnswer::new);
        this.registerPacket(5, RetrogenChangeRequest.class, RetrogenChangeRequest::new);
        this.registerPacket(6, RetrogenChangeAnswer.class, RetrogenChangeAnswer::new);
        this.registerPacket(7, RetrogenSyncRequest.class, RetrogenSyncRequest::new);
        this.registerPacket(8, RetrogenSyncAnswer.class, RetrogenSyncAnswer::new);
        this.registerPacket(9, DimensionInfoRequest.class, DimensionInfoRequest::new);
        this.registerPacket(10, DimensionInfoAnswer.class, DimensionInfoAnswer::new);
    }

    public <T extends IPregenPacket> void registerPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.channel.registerMessage(index, packet, this::writePacket, K -> this.readPacket((FriendlyByteBuf)K, creator), this::handlePacket);
    }

    protected void writePacket(IPregenPacket packet, FriendlyByteBuf buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends IPregenPacket> T readPacket(FriendlyByteBuf buffer, Supplier<T> values) {
        try {
            IPregenPacket packet = (IPregenPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(IPregenPacket packet, Supplier<NetworkEvent.Context> provider) {
        try {
            NetworkEvent.Context context = provider.get();
            Player player = this.getPlayer(context);
            if (packet.requiresMainThread()) {
                context.enqueueWork(() -> {
                    packet.process(player);
                    context.setPacketHandled(true);
                });
            } else {
                packet.process(player);
                context.setPacketHandled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Player getPlayer(NetworkEvent.Context cont) {
        ServerPlayer entity = cont.getSender();
        return entity != null ? entity : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public void sendToServer(IPregenPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public void sendToAllPlayers(IPregenPacket packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void sendToPlayer(IPregenPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
    }
}

