/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.structures.StructureRef;
import pregenerator.common.structures.StructureWorld;

public class StructureManager {
    public static final StructureManager INSTANCE = new StructureManager();

    @SubscribeEvent
    public synchronized void onChunkSave(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)event.getWorld();
        StructureWorld structure = StructureWorld.getStructures(server);
        if (structure == null) {
            return;
        }
        for (StructureStart start : event.getChunk().m_6633_().values()) {
            structure.addStructure(server.m_5962_().m_175515_(Registry.f_122882_).m_7981_((Object)start.m_210081_()), start);
        }
    }

    @SubscribeEvent
    public synchronized void onChunkLoad(ChunkEvent.Load load) {
        ChunkAccess chunk = load.getChunk();
        if (!(chunk instanceof LevelChunk)) {
            return;
        }
        Level world = ((LevelChunk)chunk).m_62953_();
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            StructureWorld structure = StructureWorld.getStructures(server);
            if (structure == null) {
                return;
            }
            for (StructureStart start : chunk.m_6633_().values()) {
                structure.addStructure(server.m_5962_().m_175515_(Registry.f_122882_).m_7981_((Object)start.m_210081_()), start);
            }
        }
    }

    public synchronized List<StructureRef> getTrackers(ResourceKey<Level> type) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return ObjectLists.emptyList();
        }
        ServerLevel world = server.m_129880_(type);
        if (world == null) {
            return ObjectLists.emptyList();
        }
        ObjectArrayList trackers = new ObjectArrayList();
        StructureWorld structure = StructureWorld.getStructures(world);
        if (structure != null) {
            structure.getStructures(null, (Collection<StructureRef>)trackers);
        }
        return trackers;
    }
}

