/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import pregenerator.base.mixins.common.chunk.ChunkSectionMixin;

public class ChunkEntry {
    public int xPos;
    public int zPos;
    public Object2IntLinkedOpenHashMap<ResourceLocation> entityCount = new Object2IntLinkedOpenHashMap();
    public Object2IntLinkedOpenHashMap<ResourceLocation> tileEntityCount = new Object2IntLinkedOpenHashMap();
    public Object2IntLinkedOpenHashMap<ResourceLocation> biomeCount = new Object2IntLinkedOpenHashMap();
    public int entities;
    public int tileEntities;
    public int tickableTileEntities;
    public int randomBlockTicks;

    public int distance(Player player, boolean chunk) {
        long xDistance = (long)(player.m_20185_() / (double)(chunk ? 16 : 1) - (double)this.pos(this.xPos, chunk));
        long zDistance = (long)(player.m_20189_() / (double)(chunk ? 16 : 1) - (double)this.pos(this.zPos, chunk));
        return this.chunkDistance(xDistance, zDistance);
    }

    int pos(int pos, boolean chunk) {
        return chunk ? pos : pos * 16 + 16;
    }

    int chunkDistance(long distanceX, long distanceZ) {
        return (int)Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
    }

    public static ChunkEntry fromChunk(LevelChunk chunk) {
        ChunkEntry entry = new ChunkEntry();
        entry.xPos = chunk.m_7697_().f_45578_;
        entry.zPos = chunk.m_7697_().f_45579_;
        Level level = chunk.m_62953_();
        ChunkPos pos = chunk.m_7697_();
        AABB box = new AABB((double)(pos.f_45578_ * 16), (double)level.m_141937_(), (double)(pos.f_45579_ * 16), (double)(pos.f_45578_ * 16 + 16), (double)level.m_151558_(), (double)(pos.f_45579_ * 16 + 16));
        ((ServerLevel)level).m_142646_().m_142232_(box, T -> {
            entry.entityCount.addTo((Object)T.m_6095_().getRegistryName(), 1);
            ++entry.entities;
        });
        for (BlockEntity tile : chunk.m_62954_().values()) {
            entry.tileEntityCount.addTo((Object)tile.m_58903_().getRegistryName(), 1);
            ++entry.tileEntities;
            entry.tickableTileEntities = entry.tickableTileEntities + (tile.m_58900_().m_155944_(chunk.m_62953_(), tile.m_58903_()) != null ? 1 : 0);
        }
        for (LevelChunkSection section : chunk.m_7103_()) {
            section.m_188013_().m_63099_((K, T) -> entry.biomeCount.addTo((Object)((Biome)K.m_203334_()).getRegistryName(), T));
        }
        LevelChunkSection[] sections = chunk.m_7103_();
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i] == null) continue;
            entry.randomBlockTicks += ((ChunkSectionMixin)sections[i]).getTickingBlocksCount();
        }
        return entry;
    }

    public static ChunkEntry fromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation location;
        int i;
        ChunkEntry entry = new ChunkEntry();
        entry.xPos = buffer.readInt();
        entry.zPos = buffer.readInt();
        entry.entities = buffer.m_130242_();
        entry.tileEntities = buffer.m_130242_();
        entry.tickableTileEntities = buffer.m_130242_();
        entry.randomBlockTicks = buffer.m_130242_();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            location = buffer.m_130281_();
            entry.entityCount.put((Object)location, buffer.m_130242_());
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            location = buffer.m_130281_();
            entry.tileEntityCount.put((Object)location, buffer.m_130242_());
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            location = buffer.m_130281_();
            entry.biomeCount.put((Object)location, buffer.m_130242_());
        }
        return entry;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.xPos);
        buffer.writeInt(this.zPos);
        buffer.m_130130_(this.entities);
        buffer.m_130130_(this.tileEntities);
        buffer.m_130130_(this.tickableTileEntities);
        buffer.m_130130_(this.randomBlockTicks);
        buffer.m_130130_(this.entityCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.entityCount)) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130130_(entry.getIntValue());
        }
        buffer.m_130130_(this.tileEntityCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.tileEntityCount)) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130130_(entry.getIntValue());
        }
        buffer.m_130130_(this.biomeCount.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(this.biomeCount)) {
            buffer.m_130085_((ResourceLocation)entry.getKey());
            buffer.m_130130_(entry.getIntValue());
        }
    }
}

