/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.generator.ChunkLogger;

public class DiskTracker {
    public static StatisticsEntry generateStatistics() throws IOException {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path mainFolder = server.m_129843_(LevelResource.f_78182_).getParent();
        ObjectLinkedOpenHashSet mainFiles = new ObjectLinkedOpenHashSet(DiskTracker.getFolderPaths(mainFolder));
        mainFiles.removeIf(DiskTracker::isDimensionFolder);
        mainFiles.removeIf(DiskTracker::isVanillaFolder);
        StatisticsEntry root = new StatisticsEntry("Root");
        root.addChild(DiskTracker.createDimensionStats(mainFolder));
        root.addChild(DiskTracker.createPlayerStats(mainFolder));
        StatisticsEntry misc = new StatisticsEntry("Misc");
        misc.addChild(new StatisticsEntry("Configs", DiskTracker.countFolder(mainFolder.resolve("serverconfig"))));
        misc.addChild(new StatisticsEntry("Datapacks", DiskTracker.countFolder(mainFolder.resolve("datapacks"))));
        for (Path path : mainFiles) {
            misc.addChild(new StatisticsEntry(ChunkLogger.toPascalCase(path.getFileName().toString()), DiskTracker.countFolder(path)));
        }
        root.addChild(misc);
        return root;
    }

    private static StatisticsEntry createDimensionStats(Path mainPath) throws IOException {
        StatisticsEntry result = new StatisticsEntry("Dimensions");
        result.addChild(DiskTracker.createDimensionStats(mainPath, "Overworld", true));
        result.addChild(DiskTracker.createDimensionStats(mainPath.resolve("DIM-1"), "Nether", false));
        result.addChild(DiskTracker.createDimensionStats(mainPath.resolve("DIM1"), "End", false));
        if (Files.exists(mainPath.resolve("dimensions"), new LinkOption[0])) {
            for (Path path : DiskTracker.getFolderPaths(mainPath.resolve("dimensions"))) {
                result.addChild(DiskTracker.createDimensionStats(path, ChunkLogger.toPascalCase(path.getFileName().toString()), false));
            }
        }
        return result;
    }

    private static StatisticsEntry createDimensionStats(Path dimFolder, String name, boolean overworld) throws IOException {
        StatisticsEntry result = new StatisticsEntry(name);
        for (Path path : overworld ? DiskTracker.getOverworldFolders(dimFolder) : DiskTracker.getFolderPaths(dimFolder)) {
            result.addChild(new StatisticsEntry(ChunkLogger.toPascalCase(path.getFileName().toString()), DiskTracker.countFolder(path)));
        }
        return result;
    }

    private static StatisticsEntry createPlayerStats(Path mainFolder) throws IOException {
        StatisticsEntry playerStats = new StatisticsEntry("PlayerData");
        playerStats.addChild(new StatisticsEntry("Advancements", DiskTracker.countFolder(mainFolder.resolve("advancements"))));
        playerStats.addChild(new StatisticsEntry("Data", DiskTracker.countFolder(mainFolder.resolve("playerdata"))));
        playerStats.addChild(new StatisticsEntry("Stats", DiskTracker.countFolder(mainFolder.resolve("stats"))));
        return playerStats;
    }

    private static boolean isVanillaFolder(Path path) {
        String name = path.getFileName().toString();
        return name.equals("stats") || name.equals("advancements") || name.equals("playerdata") || name.equals("datapacks") || name.equals("serverconfig");
    }

    private static boolean isDimensionFolder(Path path) {
        String name = path.getFileName().toString();
        return name.startsWith("DIM") || name.equals("dimensions") || name.equals("data") || name.equals("entities") || name.equals("poi") || name.equals("region");
    }

    private static List<Path> getOverworldFolders(Path path) {
        ObjectArrayList paths = new ObjectArrayList();
        for (String s : new String[]{"data", "entities", "poi", "region"}) {
            paths.add(path.resolve(s));
        }
        return paths;
    }

    private static List<Path> getFolderPaths(Path path) throws IOException {
        ObjectArrayList paths = new ObjectArrayList();
        for (Path file : Files.newDirectoryStream(path)) {
            paths.add(file);
        }
        return paths;
    }

    private static LongSummaryStatistics countFolder(Path path) throws IOException {
        LongSummaryStatistics statistics = new LongSummaryStatistics();
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        for (Path file : Files.walk(path, new FileVisitOption[0]).filter((Predicate<Path>)Predicates.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).toList()) {
            statistics.accept(Files.size(file));
        }
        return statistics;
    }

    public static class StatisticsEntry {
        String name;
        StatisticsEntry parent;
        LongSummaryStatistics result;
        Map<String, StatisticsEntry> children = new Object2ObjectLinkedOpenHashMap();

        private StatisticsEntry() {
        }

        public StatisticsEntry(String name) {
            this(name, new LongSummaryStatistics());
        }

        public StatisticsEntry(String name, LongSummaryStatistics result) {
            this.name = name;
            this.result = result;
        }

        public void addChild(StatisticsEntry stats) {
            if (stats.result == null) {
                return;
            }
            this.result.combine(stats.result);
            this.children.put(stats.getName(), stats);
            stats.parent = this;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public Map<String, StatisticsEntry> getChildren() {
            return this.children;
        }

        public String getName() {
            return this.name;
        }

        public double getPercentage() {
            if (this.parent == null) {
                return 0.0;
            }
            return (double)this.result.getSum() / (double)this.parent.result.getSum();
        }

        public String getUsage() {
            long bytes = this.result.getSum();
            if (bytes > 0x140000000L) {
                return (bytes >> 30) + " GB";
            }
            if (bytes > 0x500000L) {
                return (bytes >> 20) + " MB";
            }
            if (bytes > 5120L) {
                return (bytes >> 10) + " KB";
            }
            return bytes + " Bytes";
        }

        public String getFileCount() {
            return this.result.getCount() + " Files";
        }

        public LongSummaryStatistics getResult() {
            return this.result;
        }

        public void read(FriendlyByteBuf buf) {
            this.name = buf.m_130277_();
            this.result = new LongSummaryStatistics(buf.readLong(), 0L, 0L, buf.readLong());
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                StatisticsEntry child = new StatisticsEntry();
                child.read(buf);
                this.children.put(child.getName(), child);
                child.parent = this;
            }
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.name);
            buf.writeLong(this.result.getCount());
            buf.writeLong(this.result.getSum());
            buf.m_130130_(this.children.size());
            for (StatisticsEntry child : this.children.values()) {
                child.write(buf);
            }
        }
    }
}

