/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import pregenerator.common.utils.config.ConfigEntry;
import pregenerator.common.utils.config.ConfigSection;
import pregenerator.common.utils.config.FileSystemWatcher;

public class Config {
    private String name;
    private Object2ObjectMap<String, ConfigSection> sections = new Object2ObjectLinkedOpenHashMap();

    public Config(String name) {
        if (FileSystemWatcher.check(name)) {
            throw new IllegalArgumentException("Config name must not be null, empty or start/end with white spaces");
        }
        this.name = name;
    }

    public ConfigSection add(ConfigSection section) {
        if (section.getParent() != null) {
            throw new IllegalStateException("ConfigSection must not be added to multiple sections. Section: " + section.getName());
        }
        this.sections.putIfAbsent((Object)section.getName(), (Object)section);
        return section;
    }

    public ConfigSection add(String name) {
        ConfigSection section = (ConfigSection)this.sections.get((Object)name);
        if (section == null) {
            section = new ConfigSection(name);
            this.sections.put((Object)name, (Object)section);
        }
        return section.setUsed();
    }

    public ConfigSection getSection(String name) {
        return (ConfigSection)this.sections.get((Object)name);
    }

    ConfigSection getSectionRecursive(String[] names) {
        if (names.length == 0) {
            return null;
        }
        ConfigSection section = (ConfigSection)this.sections.get((Object)names[0]);
        if (section == null) {
            section = new ConfigSection(names[0]);
            this.sections.put((Object)names[0], (Object)section);
        }
        for (int i = 1; i < names.length && section != null; section = section.parseSubSection(names[i]), ++i) {
        }
        return section;
    }

    public List<ConfigSection> getChildren() {
        return new ObjectArrayList(this.sections.values());
    }

    public Map<String, ConfigEntry<?>> getSyncedEntries() {
        Object2ObjectLinkedOpenHashMap result = new Object2ObjectLinkedOpenHashMap();
        for (ConfigSection section : this.sections.values()) {
            section.getSyncedEntries((Map<String, ConfigEntry<?>>)result);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void resetDefault() {
        this.sections.values().forEach(ConfigSection::resetDefault);
    }

    public boolean hasChanged() {
        for (ConfigSection section : this.sections.values()) {
            if (!section.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String serialize() {
        if (this.sections.size() == 0) {
            return null;
        }
        StringJoiner joiner = new StringJoiner("\n\n");
        Object2ObjectMaps.fastForEach(this.sections, entry -> {
            String val = ((ConfigSection)entry.getValue()).serialize();
            if (val != null) {
                joiner.add(val);
            }
        });
        return joiner.toString();
    }
}

