/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.handler;

import fuzs.bettertridents.BetterTridents;
import fuzs.bettertridents.config.ServerConfig;
import fuzs.bettertridents.mixin.accessor.ThrownTridentAccessor;
import fuzs.bettertridents.world.entity.LastDamageSourceEntity;
import fuzs.bettertridents.world.entity.item.LoyalExperienceOrb;
import fuzs.bettertridents.world.entity.item.LoyalItemEntity;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import java.util.Collection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LoyalDropsHandler {
    public static EventResult onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit) {
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        int loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(source);
        if (loyaltyLevel > 0) {
            for (ItemEntity itemEntity : drops) {
                itemEntity = new LoyalItemEntity(itemEntity, source.m_7639_().m_142081_(), loyaltyLevel);
                entity.f_19853_.m_7967_((Entity)itemEntity);
            }
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(LivingEntity entity, @Nullable Player attackingPlayer, DefaultedInt droppedExperience) {
        int loyaltyLevel;
        if (!((ServerConfig)BetterTridents.CONFIG.get(ServerConfig.class)).loyaltyCapturesDrops) {
            return EventResult.PASS;
        }
        DamageSource source = ((LastDamageSourceEntity)entity).bettertridents$getLastDamageSource();
        if (source != null && (loyaltyLevel = LoyalDropsHandler.getLoyaltyLevel(source)) > 0) {
            LoyalDropsHandler.awardExperienceOrbs((ServerLevel)entity.f_19853_, entity.m_20182_(), droppedExperience.getAsInt(), (Player)source.m_7639_(), loyaltyLevel);
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    private static int getLoyaltyLevel(DamageSource source) {
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof ThrownTrident) {
                ThrownTrident trident = (ThrownTrident)entity2;
                return ((Byte)trident.m_20088_().m_135370_(ThrownTridentAccessor.getLoyaltyId())).byteValue();
            }
            return EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44955_, (LivingEntity)player);
        }
        return 0;
    }

    public static void awardExperienceOrbs(ServerLevel level, Vec3 pos, int amount, Player player, int loyaltyLevel) {
        while (amount > 0) {
            int i = ExperienceOrb.m_20782_((int)amount);
            amount -= i;
            level.m_7967_((Entity)new LoyalExperienceOrb((Level)level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), i, player.m_142081_(), loyaltyLevel));
        }
    }

    public static void tickLoyalEntity(Entity entity, Player owner, int loyaltyLevel) {
        entity.f_19854_ = entity.m_20185_();
        entity.f_19855_ = entity.m_20186_();
        entity.f_19856_ = entity.m_20189_();
        entity.f_19794_ = true;
        Vec3 vec3 = owner.m_146892_().m_82546_(entity.m_20182_());
        entity.m_20343_(entity.m_20185_(), entity.m_20186_() + vec3.f_82480_ * 0.015 * (double)loyaltyLevel, entity.m_20189_());
        if (entity.f_19853_.f_46443_) {
            entity.f_19791_ = entity.m_20186_();
        }
        entity.m_20256_(entity.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(0.05 * (double)loyaltyLevel)));
        entity.m_6075_();
        if (!entity.m_20096_() || entity.m_20184_().m_165925_() > (double)1.0E-5f || (entity.f_19797_ + entity.m_142049_()) % 4 == 0) {
            entity.m_6478_(MoverType.SELF, entity.m_20184_());
        }
        if (!entity.f_19853_.f_46443_ && entity.m_20184_().m_82546_(vec3).m_82556_() > 0.01) {
            entity.f_19812_ = true;
        }
    }

    @Nullable
    public static Player isAcceptableReturnOwner(Level level, @Nullable Entity owner) {
        Player player;
        return owner instanceof Player && (player = (Player)owner).m_6084_() && !player.m_5833_() ? player : null;
    }
}

