/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bettertridents.world.entity.item;

import fuzs.bettertridents.handler.LoyalDropsHandler;
import fuzs.bettertridents.init.ModRegistry;
import fuzs.bettertridents.mixin.accessor.ItemEntityAccessor;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LoyalItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(LoyalItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public LoyalItemEntity(EntityType<? extends ItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public LoyalItemEntity(ItemEntity itemEntity, UUID owner, int loyaltyLevel) {
        super((EntityType)ModRegistry.LOYAL_ITEM_ENTITY_TYPE.get(), itemEntity.f_19853_);
        this.m_32045_(itemEntity.m_32055_().m_41777_());
        this.m_20359_((Entity)itemEntity);
        ((ItemEntityAccessor)((Object)this)).setAge(itemEntity.m_32059_());
        ((ItemEntityAccessor)((Object)this)).setBobOffs(itemEntity.f_31983_);
        this.m_32052_(owner);
        if (loyaltyLevel < 1) {
            throw new IllegalStateException("Loyalty level missing from loyal item entity, was %s".formatted(loyaltyLevel));
        }
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)loyaltyLevel));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
    }

    public void m_8119_() {
        if (!this.m_32055_().m_41619_()) {
            UUID thrower = this.m_32057_();
            Player player = thrower != null ? LoyalDropsHandler.isAcceptableReturnOwner(this.f_19853_, (Entity)this.f_19853_.m_46003_(thrower)) : null;
            if (player != null) {
                LoyalDropsHandler.tickLoyalEntity((Entity)this, player, ((Byte)this.f_19804_.m_135370_(ID_LOYALTY)).byteValue());
                if (this.m_32059_() != Short.MIN_VALUE) {
                    ((ItemEntityAccessor)((Object)this)).setAge(this.m_32059_() + 1);
                }
                if (!this.f_19853_.f_46443_ && this.m_32059_() >= 6000) {
                    this.m_146870_();
                }
            } else if (!this.f_19853_.f_46443_) {
                super.m_8119_();
            }
        } else {
            super.m_8119_();
        }
    }
}

