/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fml.ModList;

public class FallbackModelLoader
implements IModelLoader<BlockModelWrapper> {
    public static final FallbackModelLoader INSTANCE = new FallbackModelLoader();

    public void m_6213_(ResourceManager resourceManager) {
    }

    public BlockModelWrapper read(JsonDeserializationContext context, JsonObject data) {
        JsonArray models = GsonHelper.m_13933_((JsonObject)data, (String)"models");
        if (models.size() < 2) {
            throw new JsonSyntaxException("Fallback model must contain at least 2 models");
        }
        for (int i = 0; i < models.size(); ++i) {
            String debugName = "models[" + i + "]";
            JsonObject entry = GsonHelper.m_13918_((JsonElement)models.get(i), (String)debugName);
            String modId = null;
            if (entry.has("fallback_mod_id")) {
                modId = GsonHelper.m_13906_((JsonObject)entry, (String)"fallback_mod_id");
            } else if (entry.has("loader")) {
                ResourceLocation loader = new ResourceLocation(GsonHelper.m_13906_((JsonObject)entry, (String)"loader"));
                modId = loader.m_135827_();
            }
            if (modId != null && !ModList.get().isLoaded(modId)) continue;
            try {
                return new BlockModelWrapper((BlockModel)context.deserialize((JsonElement)entry, BlockModel.class));
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException("Failed to parse fallback model " + debugName, (Throwable)e);
            }
        }
        throw new JsonSyntaxException("Failed to load fallback model, all " + models.size() + " variants had a failed condition");
    }

    record BlockModelWrapper(BlockModel model) implements IModelGeometry<BlockModelWrapper>
    {
        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return this.model.m_111449_(bakery, this.model, spriteGetter, modelTransform, modelLocation, true);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.model.m_5500_(modelGetter, missingTextureErrors);
        }
    }
}

