/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.items;

import com.haoict.tiab.config.TiabConfig;
import com.haoict.tiab.entities.TimeAcceleratorEntity;
import com.haoict.tiab.items.TiabCreativeTab;
import com.haoict.tiab.utils.PlaySound;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class AbstractTiabItem
extends Item {
    private static final int THIRTY_SECONDS = 20 * (Integer)TiabConfig.COMMON.eachUseDuration.get();
    private static final String[] NOTES = new String[]{"C", "D", "E", "F", "G2", "A2", "B2", "C2", "D2", "E2", "F2"};

    public AbstractTiabItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)TiabCreativeTab.TAB).m_41487_(1));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        BlockEntity targetTE = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (targetTE == null && !blockState.m_60823_()) {
            return InteractionResult.FAIL;
        }
        int nextRate = 1;
        int energyRequired = this.getEnergyCost(nextRate);
        boolean isCreativeMode = player != null && player.m_7500_();
        Optional o = level.m_45976_(TimeAcceleratorEntity.class, new AABB(pos)).stream().findFirst();
        if (o.isPresent()) {
            TimeAcceleratorEntity entityTA = (TimeAcceleratorEntity)((Object)o.get());
            int currentRate = entityTA.getTimeRate();
            int usedUpTime = THIRTY_SECONDS - entityTA.getRemainingTime();
            if ((double)currentRate >= Math.pow(2.0, (Integer)TiabConfig.COMMON.maxTimeRatePower.get() - 1)) {
                return InteractionResult.SUCCESS;
            }
            nextRate = currentRate * 2;
            int timeAdded = usedUpTime / 2;
            energyRequired = this.getEnergyCost(nextRate);
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return InteractionResult.SUCCESS;
            }
            entityTA.setTimeRate(nextRate);
            entityTA.setRemainingTime(entityTA.getRemainingTime() + timeAdded);
        } else {
            if (!this.canUse(stack, isCreativeMode, energyRequired)) {
                return InteractionResult.SUCCESS;
            }
            TimeAcceleratorEntity entityTA = new TimeAcceleratorEntity(level, pos, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            entityTA.setRemainingTime(THIRTY_SECONDS);
            level.m_7967_((Entity)entityTA);
        }
        if (!isCreativeMode) {
            this.applyDamage(stack, energyRequired);
        }
        this.playSound(level, pos, nextRate);
        return InteractionResult.SUCCESS;
    }

    public int getEnergyCost(int timeRate) {
        if (timeRate <= 1) {
            return THIRTY_SECONDS;
        }
        return timeRate / 2 * THIRTY_SECONDS;
    }

    public boolean canUse(ItemStack stack, boolean isCreativeMode, int energyRequired) {
        return this.getStoredEnergy(stack) >= energyRequired || isCreativeMode;
    }

    protected abstract int getStoredEnergy(ItemStack var1);

    protected abstract void setStoredEnergy(ItemStack var1, int var2);

    protected abstract void applyDamage(ItemStack var1, int var2);

    public void playSound(Level level, BlockPos pos, int nextRate) {
        switch (nextRate) {
            case 1: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[0]);
                break;
            }
            case 2: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[1]);
                break;
            }
            case 4: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[2]);
                break;
            }
            case 8: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[3]);
                break;
            }
            case 16: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[4]);
                break;
            }
            case 32: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[5]);
                break;
            }
            case 64: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[6]);
                break;
            }
            case 128: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[7]);
                break;
            }
            case 256: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[8]);
                break;
            }
            case 512: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[9]);
                break;
            }
            default: {
                PlaySound.playNoteBlockHarpSound(level, pos, NOTES[10]);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41746_((ItemStack)oldStack, (ItemStack)newStack);
    }
}

