/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.GsonConfig;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityEventHandler {
    private final HashMap<Tuple<Integer, Integer>, Float> damageMap = new HashMap();
    private long nextMapEvaluation = System.currentTimeMillis();

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            String savedMods = event.getEntity().getPersistentData().m_128461_(InfernalMobsCore.instance().getNBTTag());
            if (!savedMods.isEmpty() && !savedMods.equals(InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities())) {
                InfernalMobsCore.instance().addEntityModifiersByString((LivingEntity)event.getEntity(), savedMods);
            } else {
                InfernalMobsCore.instance().processEntitySpawn((LivingEntity)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        MobModifier mod;
        if (!event.getEntity().f_19853_.f_46443_ && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null && mod.onDeath()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        MobModifier mod;
        if (!event.getEntity().f_19853_.f_46443_ && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onSetAttackTarget(event.getTarget());
        }
    }

    @SubscribeEvent
    public void onEntityLivingAttacked(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingHurtEvent event) {
        if (event.getSource().m_7639_() != event.getEntityLiving()) {
            Entity attacker;
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving());
            if (mod != null) {
                event.setAmount(mod.onHurt(event.getEntityLiving(), event.getSource(), event.getAmount()));
            }
            if ((attacker = event.getSource().m_7639_()) instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)attacker)) != null) {
                event.setAmount(mod.onAttack(event.getEntityLiving(), event.getSource(), event.getAmount()));
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && (event.getSource() == DamageSource.f_19314_ || event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19315_ || event.getSource() == DamageSource.f_19310_ || event.getSource() == DamageSource.f_19308_ || event.getSource().m_7639_() instanceof FakePlayer)) {
                Tuple cpair = new Tuple((Object)((int)event.getEntityLiving().m_20185_()), (Object)((int)event.getEntityLiving().m_20189_()));
                Float value = this.damageMap.get(cpair);
                if (value == null) {
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        if (Math.abs((Integer)e.getKey().m_14418_() - (Integer)cpair.m_14418_()) >= 3 || Math.abs((Integer)e.getKey().m_14419_() - (Integer)cpair.m_14419_()) >= 3) continue;
                        e.setValue(Float.valueOf(e.getValue().floatValue() + event.getAmount()));
                        break;
                    }
                } else {
                    this.damageMap.put((Tuple<Integer, Integer>)cpair, Float.valueOf(value.floatValue() + event.getAmount()));
                    GsonConfig.saveConfig(InfernalMobsCore.instance().config, InfernalMobsCore.instance().configFile);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingFall(LivingFallEvent event) {
        MobModifier mod;
        if (!event.getEntity().f_19853_.f_46443_ && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            event.setCanceled(mod.onFall(event.getDistance()));
        }
    }

    @SubscribeEvent
    public void onEntityLivingJump(LivingEvent.LivingJumpEvent event) {
        MobModifier mod;
        if (!event.getEntity().f_19853_.f_46443_ && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onJump(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().f_19853_.f_46443_) {
            MobModifier mod;
            String savedMods;
            if (event.getEntityLiving().f_19797_ == 1 && !(savedMods = event.getEntityLiving().getPersistentData().m_128461_(InfernalMobsCore.instance().getNBTTag())).isEmpty() && !savedMods.equals(InfernalMobsCore.instance().getNBTMarkerForNonInfernalEntities())) {
                InfernalMobsCore.instance().addEntityModifiersByString(event.getEntityLiving(), savedMods);
            }
            if ((mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
                mod.onUpdate(event.getEntityLiving());
            }
            if (InfernalMobsCore.instance().config.isAntiMobFarm() && System.currentTimeMillis() > this.nextMapEvaluation) {
                if (!this.damageMap.isEmpty()) {
                    float maxDamage = 0.0f;
                    Tuple<Integer, Integer> maxC = null;
                    for (Map.Entry<Tuple<Integer, Integer>, Float> e : this.damageMap.entrySet()) {
                        float val = e.getValue().floatValue();
                        if (!(val > maxDamage)) continue;
                        maxC = e.getKey();
                        maxDamage = val;
                    }
                    if (maxC != null) {
                        System.out.println("Infernal Mobs AntiMobFarm damage check, max detected chunk damage value " + maxDamage + " near coords " + maxC.m_14418_() + ", " + maxC.m_14419_());
                        if (maxDamage > InfernalMobsCore.instance().config.getMobFarmDamageTrigger()) {
                            MinecraftForge.EVENT_BUS.post((Event)new MobFarmDetectedEvent(event.getEntityLiving().f_19853_.m_6325_(((Integer)maxC.m_14418_()).intValue(), ((Integer)maxC.m_14419_()).intValue()), InfernalMobsCore.instance().config.getMobFarmCheckIntervals(), maxDamage));
                        }
                    }
                    this.damageMap.clear();
                }
                this.nextMapEvaluation = System.currentTimeMillis() + InfernalMobsCore.instance().config.getMobFarmCheckIntervals();
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDrops(LivingDropsEvent event) {
        MobModifier mod;
        if (!event.getEntity().f_19853_.f_46443_ && (mod = InfernalMobsCore.getMobModifiers(event.getEntityLiving())) != null) {
            mod.onDropItems(event.getEntityLiving(), event.getSource(), event.getDrops(), event.getLootingLevel(), event.isRecentlyHit(), event.getLootingLevel());
            InfernalMobsCore.removeEntFromElites(event.getEntityLiving());
        }
    }

    public static class MobFarmDetectedEvent
    extends ChunkEvent {
        public final long triggeringInterval;
        public final float triggeringDamage;

        public MobFarmDetectedEvent(LevelChunk chunk, long ti, float td) {
            super((ChunkAccess)chunk);
            this.triggeringInterval = ti;
            this.triggeringDamage = td;
        }
    }
}

