/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ItemConfigHelper(List<? extends String> items, Logger logger) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)string);
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbt);
                if (!itemStack.m_41619_()) {
                    this.itemStackList.add(itemStack);
                    continue;
                }
                logger.error("item config parser could not build item: {}", (Object)string);
            }
            catch (CommandSyntaxException e) {
                logger.error("item config parser CommandSyntaxException: {}", (Object)string);
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack) {
        itemStack.m_41784_().m_128359_("id", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemStack.m_41720_()).toString());
        itemStack.m_41784_().m_128344_("Count", (byte)itemStack.m_41613_());
        return itemStack.m_41784_().toString();
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }
}

