/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MobModsPacket
implements NetworkHelper.IPacket {
    private String stringData;
    private int entID;
    private byte sentFromServer;

    public MobModsPacket() {
    }

    public MobModsPacket(String stringdata, int entIdToQuery, byte serverByte) {
        this.stringData = stringdata;
        this.entID = entIdToQuery;
        this.sentFromServer = serverByte;
    }

    @Override
    public void encode(Object msg, FriendlyByteBuf packetBuffer) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        packetBuffer.writeByte((int)mobModsPacket.sentFromServer);
        packetBuffer.writeInt(mobModsPacket.entID);
        packetBuffer.m_130072_(mobModsPacket.stringData, Short.MAX_VALUE);
    }

    @Override
    public <MSG> MSG decode(FriendlyByteBuf packetBuffer) {
        MobModsPacket mobModsPacket = new MobModsPacket();
        mobModsPacket.sentFromServer = packetBuffer.readByte();
        mobModsPacket.entID = packetBuffer.readInt();
        mobModsPacket.stringData = packetBuffer.m_130136_(Short.MAX_VALUE);
        return (MSG)mobModsPacket;
    }

    @Override
    public void handle(Object msg, Supplier<NetworkEvent.Context> contextSupplier) {
        MobModsPacket mobModsPacket = (MobModsPacket)msg;
        if (mobModsPacket.sentFromServer != 0) {
            InfernalMobsClient.onMobModsPacketToClient(mobModsPacket.stringData, mobModsPacket.entID);
            InfernalMobsCore.LOGGER.debug("client received serverside mods {} for ent-ID {}", (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
        } else {
            Entity ent;
            ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(mobModsPacket.stringData);
            InfernalMobsCore.LOGGER.debug("player {} from string {} querying server for mods of entity id {}", (Object)p, (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
            if (p != null && (ent = p.f_19853_.m_6815_(mobModsPacket.entID)) instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)ent;
                MobModifier mod = InfernalMobsCore.getMobModifiers(e);
                InfernalMobsCore.LOGGER.debug("resolves to entity {} modifiers {}", (Object)ent, (Object)mod);
                if (mod != null) {
                    mobModsPacket.stringData = mod.getLinkedModNameUntranslated();
                    InfernalMobsCore.LOGGER.debug("server sending mods {} for ent-ID {}", (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
                    InfernalMobsCore.instance().networkHelper.sendPacketToPlayer(new MobModsPacket(mobModsPacket.stringData, mobModsPacket.entID, 1), p);
                    InfernalMobsCore.instance().sendHealthPacket(e);
                }
            }
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

