/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.smartfilter.ModFilter;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ModFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/modfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 252;
    private final List<String> mods = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.f_41583_;
    private String modId = "";
    private String modName = "";

    public ModFilterScreen(ContainerSmartFilter container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
        this.f_97726_ = 176;
        this.f_97727_ = 252;
        this.mods.addAll(ModFilter.getModList(this.filterStack));
        this.mods.forEach(s -> ModularRouters.LOGGER.info("mod: " + s));
    }

    public void m_7856_() {
        super.m_7856_();
        if (((ContainerSmartFilter)this.f_97732_).getLocator().filterSlot >= 0) {
            this.m_142416_((GuiEventListener)new BackButton(this.f_97735_ - 12, this.f_97736_, p -> this.closeGUI()));
        }
        this.m_142416_((GuiEventListener)new Buttons.AddButton(this.f_97735_ + 154, this.f_97736_ + 19, p -> {
            if (!this.modId.isEmpty()) {
                CompoundTag ext = new CompoundTag();
                ext.m_128359_("ModId", this.modId);
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.ADD_STRING, ((ContainerSmartFilter)this.f_97732_).getLocator(), ext));
                ((Slot)((ContainerSmartFilter)this.m_6262_()).f_38839_.get(0)).m_5852_(ItemStack.f_41583_);
            }
        }));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.f_97735_ + 8, this.f_97736_ + 44 + i * 19, i, button -> {
                CompoundTag ext = new CompoundTag();
                ext.m_128405_("Pos", ((Buttons.DeleteButton)button).getId());
                PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.REMOVE_AT, ((ContainerSmartFilter)this.f_97732_).getLocator(), ext));
            });
            this.m_142416_((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.updateDeleteButtonVisibility();
    }

    private void updateDeleteButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).f_93624_ = i < this.mods.size();
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        String title = this.filterStack.m_41786_().getString() + (((ContainerSmartFilter)this.f_97732_).getRouter() != null ? I18n.m_118938_((String)"modularrouters.guiText.label.installed", (Object[])new Object[0]) : "");
        this.f_96547_.m_92883_(matrixStack, title, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92895_(title) / 2.0f, 8.0f, 0x404040);
        if (!this.modName.isEmpty()) {
            this.f_96547_.m_92883_(matrixStack, this.modName, 29.0f, 23.0f, 0x404040);
        }
        for (int i = 0; i < this.mods.size(); ++i) {
            String mod = ModNameCache.getModName(this.mods.get(i));
            this.f_96547_.m_92883_(matrixStack, mod, 28.0f, (float)(47 + i * 19), 0x404080);
        }
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        ItemStack inSlot = (ItemStack)((ContainerSmartFilter)this.m_6262_()).m_38927_().get(0);
        if (inSlot.m_41619_() && !this.prevInSlot.m_41619_()) {
            this.modName = "";
            this.modId = "";
        } else if (!(inSlot.m_41619_() || !this.prevInSlot.m_41619_() && inSlot.m_41726_(this.prevInSlot))) {
            this.modId = inSlot.m_41720_().getRegistryName().m_135827_();
            this.modName = ModNameCache.getModName(this.modId);
        }
        this.prevInSlot = inSlot;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.bindTexture(TEXTURE_LOCATION);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.mods.clear();
        this.mods.addAll(ModFilter.getModList(filterStack));
        this.updateDeleteButtonVisibility();
    }
}

