/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.InspectionMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InspectionFilter
extends SmartFilterItem {
    private static final String NBT_MATCH_ALL = "MatchAll";
    private static final String NBT_ITEMS = "Items";
    public static final String NBT_COMPARISON = "Comparison";
    public static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new InspectionMatcher(InspectionFilter.getComparisonList(filterStack));
    }

    @Override
    public boolean hasContainer() {
        return false;
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(itemstack);
        if (!comparisonList.items.isEmpty()) {
            list.add((Component)new TextComponent(ChatFormatting.YELLOW + I18n.m_118938_((String)("modularrouters.guiText.label.matchAll." + comparisonList.isMatchAll()), (Object[])new Object[0]) + ":"));
            for (InspectionMatcher.Comparison c : comparisonList.items) {
                list.add((Component)new TextComponent(ChatFormatting.AQUA + "\u2022 ").m_7220_(c.asLocalizedText()));
            }
        }
    }

    public static InspectionMatcher.ComparisonList getComparisonList(ItemStack filterStack) {
        CompoundTag compound = filterStack.m_41737_("modularrouters");
        if (compound != null) {
            boolean matchAll = compound.m_128471_(NBT_MATCH_ALL);
            ArrayList l = Lists.newArrayList();
            ListTag items = compound.m_128437_(NBT_ITEMS, 8);
            for (int i = 0; i < items.size(); ++i) {
                l.add(InspectionMatcher.Comparison.fromString(items.m_128778_(i)));
            }
            return new InspectionMatcher.ComparisonList(l, matchAll);
        }
        return new InspectionMatcher.ComparisonList(Lists.newArrayList(), false);
    }

    private void setComparisonList(ItemStack filterStack, InspectionMatcher.ComparisonList comparisonList) {
        ListTag l = comparisonList.items.stream().map(comp -> StringTag.m_129297_((String)comp.toString())).collect(Collectors.toCollection(ListTag::new));
        CompoundTag compound = filterStack.m_41698_("modularrouters");
        compound.m_128379_(NBT_MATCH_ALL, comparisonList.isMatchAll());
        compound.m_128365_(NBT_ITEMS, (Tag)l);
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        InspectionMatcher.ComparisonList comparisonList = InspectionFilter.getComparisonList(filterStack);
        switch (message.getOp()) {
            case ADD_STRING: {
                if (comparisonList.items.size() >= 6) break;
                InspectionMatcher.Comparison c = InspectionMatcher.Comparison.fromString(message.getPayload().m_128461_(NBT_COMPARISON));
                comparisonList.items.add(c);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getPayload().m_128451_("Pos");
                if (pos < 0 || pos >= comparisonList.items.size()) break;
                comparisonList.items.remove(pos);
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
            case ANY_ALL_FLAG: {
                comparisonList.setMatchAll(message.getPayload().m_128471_(NBT_MATCH_ALL));
                this.setComparisonList(filterStack, comparisonList);
                return new GuiSyncMessage(filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return 0;
    }
}

