/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.TemplateFrameBlock;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.ContainerExtruder2Module;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModBlocks;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule1;
import me.desht.modularrouters.util.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledExtruderModule2
extends CompiledExtruderModule1 {
    private final List<ItemStack> blockList;
    private final boolean mimic;

    public CompiledExtruderModule2(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
        ItemStack stack1;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        this.mimic = this.getAugmentCount((Item)ModItems.MIMIC_AUGMENT.get()) > 0;
        ContainerExtruder2Module.TemplateHandler handler = new ContainerExtruder2Module.TemplateHandler(stack, router);
        for (int i = 0; i < handler.getSlots() && stacks.size() < this.getRange() && !(stack1 = handler.getStackInSlot(i)).m_41619_(); ++i) {
            for (int j = 0; j < stack1.m_41613_() && stacks.size() < this.getRange(); ++j) {
                stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack1, (int)1));
            }
        }
        this.blockList = ImmutableList.copyOf(stacks);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        boolean extend = this.shouldExtend(router);
        Level world = router.nonNullLevel();
        if (extend && this.distance < this.blockList.size()) {
            if (!(this.blockList.get(this.distance).m_41720_() instanceof BlockItem)) {
                router.getExtensionData().m_128405_("ExtruderDist" + this.getFacing(), ++this.distance);
            } else {
                BlockPos placePos = router.m_58899_().m_5484_(this.getFacing(), this.distance + 1);
                BlockState state = ((TemplateFrameBlock)((Object)ModBlocks.TEMPLATE_FRAME.get())).m_49966_();
                if (BlockUtil.tryPlaceBlock(router, state, world, placePos)) {
                    world.m_141902_(placePos, (BlockEntityType)ModBlockEntities.TEMPLATE_FRAME.get()).ifPresent(te -> {
                        te.setCamouflage(this.blockList.get(this.distance), this.getFacing(), this.getRouterFacing());
                        te.setExtendedMimic(this.mimic);
                        if (this.mimic) {
                            world.m_46672_(placePos, state.m_60734_());
                        }
                    });
                    router.playSound(null, placePos, state.m_60734_().getSoundType(state, (LevelReader)world, placePos, null).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.5f + (float)this.distance * 0.1f);
                    router.getExtensionData().m_128405_("ExtruderDist" + this.getFacing(), ++this.distance);
                    this.tryPushEntities(router.m_58904_(), placePos, this.getFacing());
                    return true;
                }
            }
        } else if (!extend && this.distance > 0) {
            BlockPos breakPos = router.m_58899_().m_5484_(this.getFacing(), this.distance);
            BlockState oldState = world.m_8055_(breakPos);
            router.getExtensionData().m_128405_("ExtruderDist" + this.getFacing(), --this.distance);
            if (this.okToBreak(oldState)) {
                if (oldState.m_60734_() == ModBlocks.TEMPLATE_FRAME.get()) {
                    world.m_7471_(breakPos, false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean okToBreak(BlockState state) {
        Block b = state.m_60734_();
        return state.m_60795_() || b == ModBlocks.TEMPLATE_FRAME.get() || b instanceof IFluidBlock;
    }
}

