/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class NBTExtractionOperator
implements IOperator {
    public static ResourceLocation UNIQUE_NAME = new ResourceLocation("integratednbt", "nbt_extraction");
    private NBTPath extractionPath;
    private byte defaultNBTId;

    public NBTExtractionOperator(NBTPath extractionPath, byte defaultNBTId) {
        this.extractionPath = extractionPath;
        this.defaultNBTId = defaultNBTId;
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    public byte getDefaultNBTId() {
        return this.defaultNBTId;
    }

    public ResourceLocation getUniqueName() {
        return UNIQUE_NAME;
    }

    public MutableComponent getLocalizedNameFull() {
        return new TranslatableComponent("integratednbt:nbt_extraction_operator.full_name");
    }

    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo) {
        String operatorName = L10NHelpers.localize((String)this.getTranslationKey(), (Object[])new Object[0]);
        String categoryName = L10NHelpers.localize((String)this.getUnlocalizedCategoryName(), (Object[])new Object[0]);
        String symbol = this.getSymbol();
        String outputTypeName = L10NHelpers.localize((String)this.getOutputType().getTranslationKey(), (Object[])new Object[0]);
        lines.add((Component)new TranslatableComponent("operator.integrateddynamics.tooltip.operator_name", new Object[]{operatorName, symbol}));
        lines.add((Component)new TranslatableComponent("operator.integrateddynamics.tooltip.operator_category", new Object[]{categoryName}));
        lines.add((Component)new TranslatableComponent("operator.integrateddynamics.tooltip.input_type_name", new Object[]{1, new TranslatableComponent(ValueTypes.NBT.getTranslationKey()).m_6270_(Style.f_131099_.m_131140_(ValueTypes.NBT.getDisplayColorFormat()))}));
        lines.add((Component)new TranslatableComponent("operator.integrateddynamics.tooltip.output_type_name", new Object[]{this.getOutputType().getDisplayColorFormat() + outputTypeName}));
    }

    public String getTranslationKey() {
        return "integratednbt:nbt_extraction_operator.name";
    }

    public String getUnlocalizedCategoryName() {
        return "integratednbt:nbt_extraction_operator.category_name";
    }

    public String getSymbol() {
        return this.extractionPath.getCompactDisplayText();
    }

    public IValueType<?> getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    public IValueType<?>[] getInputTypes() {
        return new IValueType[]{ValueTypes.NBT};
    }

    public IValueType<?> getConditionalOutputType(IVariable[] input) {
        try {
            Tag extracted;
            IValue value;
            if (input.length == 1 && (value = input[0].getValue()) instanceof ValueTypeNbt.ValueNbt && (extracted = this.extractionPath.extract(((ValueTypeNbt.ValueNbt)value).getRawValue().orElse(null))) != null) {
                return NBTValueConverter.mapNBTToValueType(extracted);
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        return NBTValueConverter.mapNBTIDToValueType(this.defaultNBTId);
    }

    public IValue evaluate(IVariable ... input) throws EvaluationException {
        Tag extracted;
        IValue value;
        if (input.length == 1 && (value = input[0].getValue()) instanceof ValueTypeNbt.ValueNbt && (extracted = this.extractionPath.extract(((ValueTypeNbt.ValueNbt)value).getRawValue().orElse(null))) != null) {
            return NBTValueConverter.mapNBTToValue(extracted);
        }
        return NBTValueConverter.getDefaultValue(this.defaultNBTId);
    }

    public int getRequiredInputLength() {
        return 1;
    }

    public MutableComponent validateTypes(IValueType[] input) {
        if (input.length != 1) {
            return new TranslatableComponent("operator.integrateddynamics.error.wrong_input_length", new Object[]{new TranslatableComponent("integratednbt:nbt_extraction_operator.full_name"), input.length, 1});
        }
        IValueType inputType = input[0];
        if (inputType == null) {
            return new TranslatableComponent("operator.integrateddynamics.error.null_type", new Object[]{new TranslatableComponent("integratednbt:nbt_extraction_operator.full_name"), "0"});
        }
        if (!ValueHelpers.correspondsTo((IValueType)ValueTypes.NBT, (IValueType)inputType)) {
            return new TranslatableComponent("operator.integrateddynamics.error.wrong_type", new Object[]{new TranslatableComponent("integratednbt:nbt_extraction_operator.full_name"), new TranslatableComponent(inputType.getTranslationKey()), "1", new TranslatableComponent(ValueTypes.NBT.getTranslationKey())});
        }
        return null;
    }

    public IConfigRenderPattern getRenderPattern() {
        return null;
    }

    public IOperator materialize() {
        return this;
    }
}

