/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nonnull;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.CabledHorizontalBlock;
import me.tepis.integratednbt.ItemGroups;
import me.tepis.integratednbt.NBTExtractorBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.jetbrains.annotations.Nullable;

public class NBTExtractor
extends CabledHorizontalBlock
implements EntityBlock {
    public static final String REGISTRY_NAME = "nbt_extractor";

    public NBTExtractor(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return type == Additions.NBT_EXTRACTOR_BE.get() ? NBTExtractorBE::tick : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Override
    public void m_6810_(BlockState oldState, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) instanceof NBTExtractorBE) {
            NBTExtractorBE inventory = (NBTExtractorBE)tileEntity;
            for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)inventory.m_8020_(slot));
            }
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!world.f_46443_) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (WrenchHelpers.isWrench((Player)player, (ItemStack)heldItem, (Level)world, (BlockPos)blockPos, (Direction)rayTraceResult.m_82434_()) && player.m_6047_()) {
                Block.m_49881_((BlockState)blockState, (Level)world, (BlockPos)blockPos, (BlockEntity)world.m_7702_(blockPos), (Entity)player, (ItemStack)heldItem);
                world.m_46961_(blockPos, false);
                return InteractionResult.SUCCESS;
            }
            if (heldItem.m_41720_() == Additions.NBT_EXTRACTOR_REMOTE.get()) {
                return InteractionResult.PASS;
            }
            if (!player.m_6047_()) {
                this.playerAccess(world, blockPos, playerMP);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void playerAccess(Level world, BlockPos pos, ServerPlayer playerMP) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof NBTExtractorBE) {
            NBTExtractorBE nbtExtractorTileEntity = (NBTExtractorBE)tileentity;
            nbtExtractorTileEntity.refreshVariables(true);
            NetworkHooks.openGui((ServerPlayer)playerMP, (MenuProvider)nbtExtractorTileEntity, (BlockPos)pos);
        }
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new NBTExtractorBE(blockPos, blockState);
    }

    public static class NBTExtractorBlockItem
    extends BlockItem {
        public NBTExtractorBlockItem() {
            super((Block)Additions.NBT_EXTRACTOR_BLOCK.get(), new Item.Properties().m_41491_(ItemGroups.ITEM_GROUP));
        }

        public void m_7373_(@Nonnull ItemStack itemStack, @javax.annotation.Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
            super.m_7373_(itemStack, world, tooltip, flag);
            tooltip.add((Component)new TranslatableComponent("integratednbt:nbt_extractor.tooltip"));
        }
    }
}

