/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.ItemGroups;
import me.tepis.integratednbt.NBTExtractor;
import me.tepis.integratednbt.network.PacketHandler;
import me.tepis.integratednbt.network.serverbound.NBTExtractorRemoteRequestMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class NBTExtractorRemote
extends Item {
    public static final String REGISTRY_NAME = "nbt_extractor_remote";

    public NBTExtractorRemote() {
        super(new Item.Properties().m_41491_(ItemGroups.ITEM_GROUP).m_41487_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        if (world.f_46443_) {
            this.clientUse(player.m_21120_(hand), player);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUse(ItemStack itemStack, Player player) {
        CompoundTag nbt = this.getModNBT(itemStack);
        if (!nbt.m_128441_("world")) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.need_bind"), Util.f_137441_);
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.f_137441_);
            return;
        }
        if (!world.m_46472_().m_135782_().toString().equals(nbt.m_128461_("world"))) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.require_dim"), Util.f_137441_);
            return;
        }
        BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        if (!world.isAreaLoaded(pos, 1)) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.require_load_client"), Util.f_137441_);
            return;
        }
        if (world.m_8055_(pos).m_60734_() != Additions.NBT_EXTRACTOR_BLOCK.get()) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.f_137441_);
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorRemoteRequestMessage());
    }

    public CompoundTag getModNBT(ItemStack itemStack) {
        return itemStack.m_41698_("integratednbt");
    }

    public void serverUse(ItemStack itemStack, ServerPlayer player) {
        CompoundTag nbt = this.getModNBT(itemStack);
        if (!nbt.m_128441_("world")) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.need_bind"), Util.f_137441_);
            return;
        }
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("world")));
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.f_137441_);
            return;
        }
        ServerLevel world = server.m_129880_(dimensionKey);
        if (world == null) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.f_137441_);
            return;
        }
        BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        if (!world.isAreaLoaded(pos, 1)) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.require_load_server"), Util.f_137441_);
            return;
        }
        if (world.m_8055_(pos).m_60734_() != Additions.NBT_EXTRACTOR_BLOCK.get()) {
            player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.invalid_bind"), Util.f_137441_);
            return;
        }
        ((NBTExtractor)((Object)Additions.NBT_EXTRACTOR_BLOCK.get())).playerAccess((Level)world, pos, player);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext itemUseContext) {
        Level world = itemUseContext.m_43725_();
        BlockPos pos = itemUseContext.m_8083_();
        Player player = itemUseContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = itemUseContext.m_43724_();
        if (world.m_8055_(pos).m_60734_() == Additions.NBT_EXTRACTOR_BLOCK.get()) {
            if (!world.f_46443_) {
                ((NBTExtractorRemote)((Object)Additions.NBT_EXTRACTOR_REMOTE.get())).bindBlock(player.m_21120_(hand), world, pos);
                player.m_6352_((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.bind_successful", new Object[]{String.valueOf(pos.m_123341_()), String.valueOf(pos.m_123342_()), String.valueOf(pos.m_123343_())}), Util.f_137441_);
            }
        } else if (world.f_46443_) {
            this.clientUse(player.m_21120_(hand), player);
        }
        return InteractionResult.SUCCESS;
    }

    public void bindBlock(ItemStack itemStack, Level world, BlockPos pos) {
        CompoundTag nbt = this.getModNBT(itemStack);
        nbt.m_128359_("world", world.m_46472_().m_135782_().toString());
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(itemStack, world, tooltip, flag);
        CompoundTag nbt = this.getModNBT(itemStack);
        if (nbt.m_128441_("world")) {
            tooltip.add((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.tooltip.bound", new Object[]{String.valueOf(nbt.m_128451_("x")), String.valueOf(nbt.m_128451_("y")), String.valueOf(nbt.m_128451_("z")), nbt.m_128461_("world")}).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)));
        } else {
            tooltip.add((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.tooltip.not_bound"));
        }
        tooltip.add((Component)new TranslatableComponent("integratednbt:nbt_extractor_remote.tooltip"));
    }
}

