/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.tepis.integratednbt.ExtendedContainerScreen;
import me.tepis.integratednbt.HoverTextImageButton;
import me.tepis.integratednbt.NBTExtractorBE;
import me.tepis.integratednbt.NBTExtractorContainer;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTTreeViewer;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import me.tepis.integratednbt.network.PacketHandler;
import me.tepis.integratednbt.network.clientbound.NBTExtractorUpdateClientMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateAutoRefreshMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateExtractionPathMessage;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateOutputModeMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class NBTExtractorScreen
extends ExtendedContainerScreen<NBTExtractorContainer> {
    public static final int SCREEN_EDGE = 4;
    public static final Texture GUI_TEXTURE = new Texture("integratednbt", "textures/gui/nbt_extractor.png");
    private static final TexturePart PART0 = GUI_TEXTURE.createPart(0, 0, 8, 24);
    private static final TexturePart PART1 = GUI_TEXTURE.createPart(12, 0, 4, 24);
    private static final TexturePart PART2 = GUI_TEXTURE.createPart(20, 0, 8, 24);
    private static final TexturePart PART3 = GUI_TEXTURE.createPart(0, 28, 8, 4);
    private static final TexturePart PART4 = GUI_TEXTURE.createPart(12, 28, 4, 4);
    private static final TexturePart PART5 = GUI_TEXTURE.createPart(20, 28, 8, 4);
    private static final TexturePart PART6 = GUI_TEXTURE.createPart(0, 36, 8, 8);
    private static final TexturePart PART7 = GUI_TEXTURE.createPart(12, 36, 4, 8);
    private static final TexturePart PART8 = GUI_TEXTURE.createPart(20, 36, 178, 110);
    private static final TexturePart PART9 = GUI_TEXTURE.createPart(202, 36, 8, 8);
    private static final int BUTTON_SIZE = 12;
    private static final TexturePart BUTTON_UNKNOWN = GUI_TEXTURE.createPart(78, 0, 12, 12);
    private static final TexturePart BUTTON_UNKNOWN_HOVER = GUI_TEXTURE.createPart(78, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON = GUI_TEXTURE.createPart(126, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_ON_HOVER = GUI_TEXTURE.createPart(126, 12, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF = GUI_TEXTURE.createPart(138, 0, 12, 12);
    private static final TexturePart BUTTON_REFRESH_OFF_HOVER = GUI_TEXTURE.createPart(138, 12, 12, 12);
    private static final int BASE_PADDING = 200;
    private static final int INVENTORY_WIDTH = 178;
    private static final int INVENTORY_HEIGHT = 110;
    private static final int TOP_BORDER_SIZE = 24;
    private static final int SIDE_BORDER_SIZE = 8;
    private static final double CENTERED_TEXT_MAX_RATIO = 0.8;
    private static final int BUTTON_SPACING = 2;
    private static NBTExtractorScreen lastInstance = null;
    private static NBTExtractorUpdateClientMessage.ErrorCode errorCode = null;
    private static Tag nbt;
    private static NBTPath extractionPath;
    private static NBTExtractorOutputMode outputMode;
    private static Component errorMessage;
    private static Boolean autoRefresh;
    private NBTTreeViewer treeViewer;
    private NBTExtractorContainer nbtExtractorContainer;
    private Font fontRenderer;
    private int padding;
    private int screenWidth;
    private int screenHeight;
    private double scaleFactor;
    private HoverTextImageButton outputModeButton;
    private HoverTextImageButton autoRefreshButton;

    public NBTExtractorScreen(NBTExtractorContainer screenContainer, Inventory inventory, Component title) {
        super(screenContainer, inventory, title);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        lastInstance = this;
        this.nbtExtractorContainer = screenContainer;
        NBTExtractorBE tileEntity = this.nbtExtractorContainer.getNbtExtractorEntity();
        this.treeViewer = new NBTTreeViewer(this, tileEntity.getExpandedPaths(), tileEntity.getScrollTop()){

            @Override
            public void onUpdateSelectedPath(NBTPath newPath, Tag nbt) {
                PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateExtractionPathMessage(NBTExtractorScreen.this.nbtExtractorContainer.getNbtExtractorEntity().m_58899_(), newPath, nbt.m_7060_()));
            }

            @Override
            public NBTPath getSelectedPath() {
                return extractionPath;
            }
        };
    }

    public static void updateError(NBTExtractorUpdateClientMessage.ErrorCode errorCode) {
        NBTExtractorScreen.errorCode = errorCode;
    }

    public static void updateNBT(Tag nbt) {
        NBTExtractorScreen.nbt = nbt;
    }

    public static void updateExtractionPath(NBTPath extractionPath) {
        NBTExtractorScreen.extractionPath = extractionPath;
    }

    public static void updateOutputMode(NBTExtractorOutputMode outputMode) {
        NBTExtractorScreen.outputMode = outputMode;
        if (lastInstance != null) {
            lastInstance.updateOutputModeButton();
        }
    }

    private void updateOutputModeButton() {
        if (this.outputModeButton == null) {
            return;
        }
        ArrayList<Component> messages = new ArrayList<Component>();
        if (outputMode == null) {
            this.outputModeButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add((Component)new TranslatableComponent("integratednbt:nbt_extractor.output_mode", new Object[]{new TranslatableComponent("integratednbt:nbt_extractor.loading")}));
        } else {
            this.outputModeButton.setTexture(outputMode.getButtonTextureNormal(), outputMode.getButtonTextureHover());
            messages.add((Component)new TranslatableComponent("integratednbt:nbt_extractor.output_mode", new Object[]{outputMode.getName()}));
        }
        messages.add((Component)new TranslatableComponent("integratednbt:nbt_extractor.output_mode.description.begin").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        messages.add((Component)new TextComponent(" "));
        Arrays.stream(NBTExtractorOutputMode.values()).forEach(describingOutputMode -> messages.add(describingOutputMode.getDescription(describingOutputMode.equals((Object)outputMode))));
        messages.add((Component)new TextComponent(" "));
        messages.add((Component)new TranslatableComponent("integratednbt:nbt_extractor.output_mode.description.end", new Object[]{NBTExtractorOutputMode.REFERENCE.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        this.outputModeButton.setHoverText(messages);
    }

    public static void updateErrorMessage(Component errorMessage) {
        NBTExtractorScreen.errorMessage = errorMessage;
    }

    public static void updateAutoRefresh(Boolean autoRefresh) {
        NBTExtractorScreen.autoRefresh = autoRefresh;
        if (lastInstance != null) {
            lastInstance.updateAutoRefreshButton();
        }
    }

    private void updateAutoRefreshButton() {
        if (this.autoRefreshButton == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (autoRefresh == null) {
            this.autoRefreshButton.setTexture(BUTTON_UNKNOWN, BUTTON_UNKNOWN_HOVER);
            messages.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.m_118938_((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0])}));
        } else if (autoRefresh.booleanValue()) {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_ON, BUTTON_REFRESH_ON_HOVER);
            messages.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh.on", (Object[])new Object[0])}));
        } else {
            this.autoRefreshButton.setTexture(BUTTON_REFRESH_OFF, BUTTON_REFRESH_OFF_HOVER);
            messages.add(I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh", (Object[])new Object[]{I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh.off", (Object[])new Object[0])}));
        }
        messages.addAll(Arrays.asList(I18n.m_118938_((String)"integratednbt:nbt_extractor.auto_refresh.description", (Object[])new Object[0]).split("\\\\n")));
        this.autoRefreshButton.setHoverTextRaw(messages);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        this.treeViewer.mouseClicked(mouseButton);
        return true;
    }

    protected void m_7856_() {
        this.updateCalculations();
        this.f_97726_ = this.f_96543_ - 2 * this.padding;
        this.f_97727_ = this.f_96544_ - 2 * this.padding;
        super.m_7856_();
        this.nbtExtractorContainer.setSlotOffset((this.f_97726_ - 178) / 2, this.f_97727_ - 110);
        this.treeViewer.updateBounds(this.padding + 8, this.padding + 24, this.screenWidth, this.screenHeight);
        this.outputModeButton = new HoverTextImageButton((Screen)this, this.f_96543_ - this.padding - 7 - 12, this.padding + 7, this::onOutputModeButtonClick);
        this.updateOutputModeButton();
        this.m_7787_((GuiEventListener)this.outputModeButton);
        this.autoRefreshButton = new HoverTextImageButton((Screen)this, this.f_96543_ - this.padding - 7 - 24 - 2, this.padding + 7, this::onAutoRefreshButtonClick);
        this.updateAutoRefreshButton();
        this.m_7787_((GuiEventListener)this.autoRefreshButton);
    }

    private void updateCalculations() {
        this.scaleFactor = Minecraft.m_91087_().m_91268_().m_85449_();
        this.padding = (int)Math.min(Math.max(200.0 / Math.pow(this.scaleFactor, 3.0), 4.0), (double)Math.min(this.f_96543_, this.f_96544_) / 10.0);
        this.screenWidth = this.f_96543_ - 2 * this.padding - 16;
        this.screenHeight = this.f_96544_ - 2 * this.padding - 24 - 110;
    }

    public void onOutputModeButtonClick(Button ignored) {
        if (outputMode == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateOutputModeMessage(this.nbtExtractorContainer.getNbtExtractorEntity().m_58899_(), NBTExtractorOutputMode.values()[(outputMode.ordinal() + 1) % NBTExtractorOutputMode.values().length]));
    }

    public void onAutoRefreshButtonClick(Button ignored) {
        if (autoRefresh == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new NBTExtractorUpdateAutoRefreshMessage(this.nbtExtractorContainer.getNbtExtractorEntity().m_58899_(), autoRefresh == false));
    }

    public boolean m_6050_(double mouseX, double mouseY, double dWheel) {
        super.m_6050_(mouseX, mouseY, dWheel);
        if (errorCode == NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR && nbt != null) {
            this.treeViewer.mouseScrolled(dWheel);
        }
        return true;
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.outputModeButton.drawHover(matrixStack, mouseX, mouseY);
        this.autoRefreshButton.drawHover(matrixStack, mouseX, mouseY);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.outputModeButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.autoRefreshButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.renderGuiParts(matrixStack);
        this.fontRenderer.m_92883_(matrixStack, I18n.m_118938_((String)"block.integratednbt.nbt_extractor", (Object[])new Object[0]), (float)(this.padding + 8), (float)(this.padding + 9), 0x404040);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)this.scaleFactor * (this.padding + 8)), (int)((int)this.scaleFactor * (this.padding + 110)), (int)((int)this.scaleFactor * this.screenWidth), (int)((int)this.scaleFactor * this.screenHeight));
        Slot srcNBTSlot = this.nbtExtractorContainer.getSrcNBTSlot();
        if (!srcNBTSlot.m_6657_()) {
            errorCode = null;
            this.renderWelcome(matrixStack);
        } else if (errorCode == null) {
            this.renderLoading(matrixStack);
        } else if (!errorCode.equals((Object)NBTExtractorUpdateClientMessage.ErrorCode.NO_ERROR)) {
            this.renderError(matrixStack);
        } else {
            this.treeViewer.render(matrixStack, nbt, mouseX, mouseY);
        }
        GL11.glDisable((int)3089);
    }

    public void m_7861_() {
        if (lastInstance == this) {
            lastInstance = null;
            errorCode = null;
            nbt = null;
            extractionPath = null;
            outputMode = null;
            errorMessage = null;
        }
        super.m_7861_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderGuiParts(PoseStack matrixStack) {
        int padding = this.padding;
        int screenWidth = this.screenWidth;
        int screenHeight = this.screenHeight;
        GUI_TEXTURE.bind();
        PART0.renderTo((GuiComponent)this, matrixStack, padding, padding);
        PART1.renderToScaled(this, matrixStack, padding + 8, padding, screenWidth, -1);
        PART2.renderTo((GuiComponent)this, matrixStack, this.f_96543_ - padding - 8, padding);
        PART3.renderToScaled(this, matrixStack, padding, padding + 24, -1, screenHeight);
        PART4.renderToScaled(this, matrixStack, padding + 8, padding + 24, screenWidth, screenHeight);
        PART5.renderToScaled(this, matrixStack, this.f_96543_ - padding - 8, padding + 24, -1, screenHeight);
        int topOfPart6789 = this.f_96544_ - padding - 110;
        PART6.renderTo((GuiComponent)this, matrixStack, padding, topOfPart6789);
        int part7Width2x = this.f_96543_ - 2 * padding - 16 - 178;
        int part7WidthFloor = (int)Math.floor((double)part7Width2x / 2.0);
        int part7WidthCeil = (int)Math.ceil((double)part7Width2x / 2.0);
        PART7.renderToScaled(this, matrixStack, padding + 8, topOfPart6789, part7WidthFloor, -1);
        PART8.renderTo((GuiComponent)this, matrixStack, padding + 8 + part7WidthFloor, topOfPart6789);
        PART7.renderToScaled(this, matrixStack, padding + 8 + part7WidthFloor + 178, topOfPart6789, part7WidthCeil, -1);
        PART9.renderTo((GuiComponent)this, matrixStack, this.f_96543_ - padding - 8, topOfPart6789);
    }

    private void renderWelcome(PoseStack matrixStack) {
        this.renderCenteredTextGroup(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.welcome", (Object[])new Object[0]), 65535, I18n.m_118938_((String)"integratednbt:nbt_extractor.welcome.description", (Object[])new Object[0]));
    }

    private void renderLoading(PoseStack matrixStack) {
        this.renderCenteredTextGroup(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.loading", (Object[])new Object[0]), 0xFFFF00, I18n.m_118938_((String)"integratednbt:nbt_extractor.loading.description", (Object[])new Object[0]));
    }

    private void renderError(PoseStack matrixStack) {
        String message = "";
        if (errorMessage != null) {
            message = errorMessage.getString();
        } else {
            switch (errorCode) {
                case EVAL_ERROR: {
                    message = I18n.m_118938_((String)"integratednbt:nbt_extractor.error.eval", (Object[])new Object[0]);
                    break;
                }
                case TYPE_ERROR: {
                    message = I18n.m_118938_((String)"integratednbt:nbt_extractor.error.type", (Object[])new Object[0]);
                    break;
                }
                case UNEXPECTED_ERROR: {
                    message = I18n.m_118938_((String)"integratednbt:nbt_extractor.error.unexpected", (Object[])new Object[0]);
                }
            }
        }
        this.renderCenteredTextGroup(matrixStack, I18n.m_118938_((String)"integratednbt:nbt_extractor.error", (Object[])new Object[0]), 0xFF5555, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderCenteredTextGroup(PoseStack matrixStack, String title, int titleColor, String description) {
        matrixStack.m_85836_();
        try {
            int x = this.screenCenterX();
            int y = this.screenCenterY();
            int titleWidth = this.fontRenderer.m_92895_(title);
            matrixStack.m_85836_();
            try {
                this.scaleAt(matrixStack, x, y, 2.0f);
                float f = (float)(-titleWidth) / 2.0f;
                Objects.requireNonNull(this.fontRenderer);
                this.fontRenderer.m_92883_(matrixStack, title, f, (float)(-9 - 1), titleColor);
            }
            finally {
                matrixStack.m_85849_();
            }
            this.scaleAt(matrixStack, x, y, 1.0f);
            int wrappingWidth = (int)((double)this.screenWidth * 0.8);
            int descriptionWidth = this.fontRenderer.m_92895_(description);
            if (descriptionWidth > wrappingWidth) {
                this.fontRenderer.m_92857_((FormattedText)new TextComponent(description), -wrappingWidth / 2, 4, wrappingWidth, 0xFFFFFF);
            } else {
                this.fontRenderer.m_92883_(matrixStack, description, (float)(-descriptionWidth) / 2.0f, 4.0f, 0xFFFFFF);
            }
        }
        finally {
            matrixStack.m_85849_();
        }
    }

    private int screenCenterX() {
        return this.f_96543_ / 2;
    }

    private int screenCenterY() {
        return this.padding + 24 + this.screenHeight / 2;
    }

    private void scaleAt(PoseStack poseStack, int x, int y, float scale) {
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_85837_((double)((float)x / scale), (double)((float)y / scale), 0.0);
    }

    static {
        extractionPath = null;
        outputMode = null;
        errorMessage = null;
        autoRefresh = null;
    }
}

