/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.tepis.integratednbt.IntegratedNBT;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.StringUtils;

public class NBTPath {
    private static final int MAX_EXTRACTION_DEPTH = 128;
    private static final String KEY_PATH = "path";
    private static final String KEY_TYPE = "type";
    private static final String TYPE_KEY = "key";
    private static final String KEY_KEY = "key";
    private static final String TYPE_INDEX = "index";
    private static final String KEY_INDEX = "index";
    private final ArrayList<Segment> segments;

    public NBTPath(ArrayList<Segment> segments) {
        this.segments = segments;
    }

    public NBTPath() {
        this.segments = new ArrayList();
    }

    public static Optional<NBTPath> fromNBT(Tag nbt) {
        try {
            if (nbt instanceof CompoundTag) {
                nbt = ((CompoundTag)nbt).m_128423_(KEY_PATH);
            }
            NBTPath.myAssert(nbt instanceof ListTag);
            ListTag list = (ListTag)nbt;
            NBTPath.myAssert(list.m_7264_() == 10 || list.size() == 0);
            NBTPath.myAssert(list.size() <= 128);
            ArrayList<Segment> segments = new ArrayList<Segment>(list.size());
            for (Tag item : list) {
                CompoundTag compound = (CompoundTag)item;
                String type = compound.m_128461_(KEY_TYPE);
                NBTPath.myAssert(!type.isEmpty());
                if (type.equals("key")) {
                    NBTPath.myAssert(compound.m_128441_("key"));
                    String key = compound.m_128461_("key");
                    NBTPath.myAssert(!key.isEmpty());
                    segments.add(new KeySegment(key));
                    continue;
                }
                NBTPath.myAssert(type.equals("index"));
                NBTPath.myAssert(compound.m_128441_("index"));
                int index = compound.m_128451_("index");
                NBTPath.myAssert(index >= 0);
                segments.add(new IndexSegment(index));
            }
            return Optional.of(new NBTPath(segments));
        }
        catch (Exception ex) {
            IntegratedNBT.LOGGER.error("Failed to decode NBT for ExtractionPath.", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static void myAssert(boolean value) {
        if (!value) {
            throw new RuntimeException("Assertion failed. D:");
        }
    }

    public void pushKey(String key) {
        this.segments.add(new KeySegment(key));
    }

    public void pushIndex(int index) {
        this.segments.add(new IndexSegment(index));
    }

    public void pop() {
        this.segments.remove(this.segments.size() - 1);
    }

    public NBTPath copy() {
        return new NBTPath((ArrayList)this.segments.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTPath that = (NBTPath)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public CompoundTag toNBTCompound() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(KEY_PATH, (Tag)this.toNBT());
        return compound;
    }

    public ListTag toNBT() {
        ListTag list = new ListTag();
        for (Segment segment : this.segments) {
            CompoundTag tag;
            if (segment instanceof KeySegment) {
                tag = new CompoundTag();
                tag.m_128359_(KEY_TYPE, "key");
                tag.m_128359_("key", ((KeySegment)segment).key);
                list.add((Object)tag);
                continue;
            }
            tag = new CompoundTag();
            tag.m_128359_(KEY_TYPE, "index");
            tag.m_128405_("index", ((IndexSegment)segment).index);
            list.add((Object)tag);
        }
        return list;
    }

    public Tag extract(Tag source) {
        for (Segment segment : this.segments) {
            if (source == null) {
                return null;
            }
            source = segment.access(source);
        }
        return source;
    }

    public String getDisplayText() {
        if (this.segments.isEmpty()) {
            return I18n.m_118938_((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]);
        }
        String arrow = I18n.m_118938_((String)"integratednbt:nbt_extractor.arrow", (Object[])new Object[0]);
        return I18n.m_118938_((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]) + arrow + this.segments.stream().map(Segment::getDisplayText).collect(Collectors.joining(arrow));
    }

    public String getCompactDisplayText() {
        if (this.segments.isEmpty()) {
            return "id";
        }
        return this.segments.stream().map(Segment::getCompactDisplayText).collect(Collectors.joining());
    }

    public int getDepth() {
        return this.segments.size();
    }

    public String getCyclopsNBTPath() {
        StringBuilder stringBuilder = new StringBuilder().append('$');
        for (Segment segment : this.segments) {
            segment.buildCyclopsNBTPath(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static class KeySegment
    implements Segment {
        private final String key;
        private static final Pattern NON_SPECIAL = Pattern.compile("^[a-zA-Z_0-9]+$");

        public KeySegment(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeySegment that = (KeySegment)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String getDisplayText() {
            return this.key;
        }

        @Override
        public String getCompactDisplayText() {
            return "." + this.key;
        }

        @Override
        public Tag access(Tag parent) {
            if (parent instanceof CompoundTag) {
                return ((CompoundTag)parent).m_128423_(this.key);
            }
            return null;
        }

        @Override
        public void buildCyclopsNBTPath(StringBuilder stringBuilder) {
            if (NON_SPECIAL.matcher(this.key).matches() && !this.key.equals("length")) {
                stringBuilder.append('.').append(this.key);
            } else {
                stringBuilder.append("[\"").append(StringUtils.replace((String)StringUtils.replace((String)this.key, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"")).append("\"]");
            }
        }
    }

    private static class IndexSegment
    implements Segment {
        private final int index;

        private IndexSegment(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexSegment that = (IndexSegment)o;
            return this.index == that.index;
        }

        public int hashCode() {
            return this.index;
        }

        @Override
        public String getDisplayText() {
            return I18n.m_118938_((String)"integratednbt:nbt_extractor.index", (Object[])new Object[]{String.valueOf(this.index)});
        }

        @Override
        public String getCompactDisplayText() {
            return "[" + this.index + "]";
        }

        @Override
        public Tag access(Tag parent) {
            if (parent instanceof ListTag) {
                ListTag parentList = (ListTag)parent;
                if (parentList.size() <= this.index || this.index < 0) {
                    return null;
                }
                Tag base = parentList.get(this.index);
                if (base.m_7060_() == 0) {
                    return null;
                }
                return base;
            }
            return null;
        }

        @Override
        public void buildCyclopsNBTPath(StringBuilder stringBuilder) {
            stringBuilder.append("[").append(this.index).append("]");
        }
    }

    private static interface Segment {
        public String getDisplayText();

        public String getCompactDisplayText();

        public Tag access(Tag var1);

        public void buildCyclopsNBTPath(StringBuilder var1);
    }
}

