/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.gui;

import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import com.hidoni.transmog.config.TransmogRenderOption;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends OptionsSubScreen {
    private final Screen parentScreen;
    private OptionsList list;

    public ConfigScreen(Screen parentScreen) {
        super(parentScreen, Minecraft.m_91087_().f_91066_, (Component)new TranslatableComponent("transmog.config_title"));
        this.parentScreen = parentScreen;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        ConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)8, (int)ChatFormatting.WHITE.m_126665_());
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        List list = ConfigScreen.m_96287_((OptionsList)this.list, (int)mouseX, (int)mouseY);
        this.m_96617_(poseStack, list, mouseX, mouseY);
    }

    protected void m_7856_() {
        Minecraft minecraft = Objects.requireNonNullElseGet(this.f_96541_, Minecraft::m_91087_);
        this.list = new OptionsList(minecraft, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.addConfigOptionsToList();
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, button -> {
            Config.writeConfigToFile();
            Objects.requireNonNullElseGet(this.f_96541_, Minecraft::m_91087_).m_91152_(this.parentScreen);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, button -> {
            this.m_7861_();
            Objects.requireNonNullElseGet(this.f_96541_, Minecraft::m_91087_).m_91152_(this.parentScreen);
        }));
    }

    private void addConfigOptionsToList() {
        CycleOption transmogRenderOptionCycleOption = CycleOption.m_167737_((String)"transmog.config.render", Arrays.asList(TransmogRenderOption.values()), option -> new TranslatableComponent(option.getKey()), options -> Config.renderOption, (options, option, value) -> {
            Config.renderOption = value;
        });
        CycleOption tooltipDetailLevelCycleOption = CycleOption.m_167737_((String)"transmog.config.tooltip", Arrays.asList(TooltipDetailLevel.values()), option -> new TranslatableComponent(option.getKey()), options -> Config.tooltipDetailLevel, (options, option, value) -> {
            Config.tooltipDetailLevel = value;
        });
        ProgressOption pvpDurationProgressOption = new ProgressOption("transmog.config.disable_during_pvp_duration", 0.0, 120.0, 1.0f, options -> Config.pvpDisableDuration, (options, value) -> {
            Config.pvpDisableDuration = (int)Math.round(value);
        }, (options, progressOption) -> new TranslatableComponent("options.generic_value", new Object[]{new TranslatableComponent("transmog.config.disable_during_pvp_duration"), Config.pvpDisableDuration == 0 ? new TranslatableComponent("transmog.config.render.off") : new TranslatableComponent("transmog.config.disable_during_pvp_duration.label", new Object[]{Config.pvpDisableDuration})}), mc -> mc.f_91062_.m_92923_((FormattedText)new TranslatableComponent("transmog.config.disable_during_pvp_duration.tooltip"), 200));
        transmogRenderOptionCycleOption.m_167773_(mc -> option -> mc.f_91062_.m_92923_((FormattedText)new TranslatableComponent(option.getTooltipKey()), 200));
        tooltipDetailLevelCycleOption.m_167773_(mc -> option -> mc.f_91062_.m_92923_((FormattedText)new TranslatableComponent(option.getTooltipKey()), 200));
        this.list.m_94471_((Option)transmogRenderOptionCycleOption);
        this.list.m_94471_((Option)tooltipDetailLevelCycleOption);
        this.list.m_94471_((Option)pvpDurationProgressOption);
    }

    public void m_7861_() {
        Config.loadConfigFromFile();
    }
}

