/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium;

import com.hrznstudio.titanium.TitaniumClient;
import com.hrznstudio.titanium._impl.creative.CreativeFEGeneratorBlock;
import com.hrznstudio.titanium._impl.test.AssetTestBlock;
import com.hrznstudio.titanium._impl.test.MachineTestBlock;
import com.hrznstudio.titanium._impl.test.TestBlock;
import com.hrznstudio.titanium._impl.test.TwentyFourTestBlock;
import com.hrznstudio.titanium.capability.CapabilityItemStackHolder;
import com.hrznstudio.titanium.client.screen.container.BasicAddonScreen;
import com.hrznstudio.titanium.command.RewardCommand;
import com.hrznstudio.titanium.command.RewardGrantCommand;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.locator.LocatorTypes;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.network.messages.TileFieldNetworkMessage;
import com.hrznstudio.titanium.recipe.condition.ContentExistsConditionSerializer;
import com.hrznstudio.titanium.recipe.generator.titanium.JsonRecipeSerializerProvider;
import com.hrznstudio.titanium.recipe.shapelessenchant.ShapelessEnchantSerializer;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.hrznstudio.titanium.util.SidedHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="titanium")
public class Titanium
extends ModuleController {
    public static final String MODID = "titanium";
    public static final Logger LOGGER = LogManager.getLogger((String)"titanium");
    public static NetworkHandler NETWORK = new NetworkHandler("titanium");

    public Titanium() {
        NETWORK.registerMessage(ButtonClickNetworkMessage.class);
        NETWORK.registerMessage(RewardSyncMessage.class);
        NETWORK.registerMessage(TileFieldNetworkMessage.class);
        SidedHandler.runOn(Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(this::clientSetup).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(this::commonSetup).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).process(this::onPlayerLoggedIn).subscribe();
        EventManager.forge(ServerStartingEvent.class).process(this::onServerStart).subscribe();
        EventManager.mod(RegisterCapabilitiesEvent.class).process(CapabilityItemStackHolder::register).subscribe();
        CraftingHelper.register((IConditionSerializer)new ContentExistsConditionSerializer());
    }

    @Override
    public void onPreInit() {
        super.onPreInit();
    }

    @Override
    public void onInit() {
        super.onInit();
    }

    @Override
    protected void initModules() {
        this.getRegistries().registerGeneric(MenuType.class, "addon_container", () -> IForgeMenuType.create(BasicAddonContainer::create));
        this.getRegistries().registerGeneric(RecipeSerializer.class, "shapeless_enchant", () -> new ShapelessEnchantSerializer());
        if (!FMLLoader.isProduction()) {
            TestBlock.TEST = this.getRegistries().registerBlockWithTile("block_test", () -> new TestBlock());
            TwentyFourTestBlock.TEST = this.getRegistries().registerBlockWithTile("block_twenty_four_test", () -> new TwentyFourTestBlock());
            AssetTestBlock.TEST = this.getRegistries().registerBlockWithTile("block_asset_test", () -> new AssetTestBlock());
            MachineTestBlock.TEST = this.getRegistries().registerBlockWithTile("machine_test", () -> new MachineTestBlock());
            CreativeFEGeneratorBlock.INSTANCE = this.getRegistries().registerBlockWithTile("creative_generator", () -> new CreativeFEGeneratorBlock());
        }
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
    }

    @Override
    public void addDataProvider(GatherDataEvent event) {
        NonNullLazy blocksToProcess = NonNullLazy.of(() -> ForgeRegistries.BLOCKS.getValues().stream().filter(basicBlock -> Optional.ofNullable(basicBlock.getRegistryName()).map(ResourceLocation::m_135827_).filter(MODID::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().m_123914_((DataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), MODID, (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new TitaniumLootTableProvider(event.getGenerator(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new JsonRecipeSerializerProvider(event.getGenerator(), MODID));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.DEDICATED_SERVER)));
        LocatorTypes.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        EventManager.forge(DrawSelectionEvent.HighlightBlock.class).process(TitaniumClient::blockOverlayEvent).subscribe();
        TitaniumClient.registerModelLoader();
        RewardManager.get().getRewards().values().forEach(rewardGiver -> rewardGiver.getRewards().forEach(reward -> reward.register(Dist.CLIENT)));
        MenuScreens.m_96206_(BasicAddonContainer.TYPE, BasicAddonScreen::new);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().m_20194_().execute(() -> {
            RewardWorldStorage storage = RewardWorldStorage.get(event.getPlayer().m_20194_().m_129880_(Level.f_46428_));
            if (!storage.getConfiguredPlayers().contains(event.getPlayer().m_142081_())) {
                for (ResourceLocation collectRewardsResourceLocation : RewardManager.get().collectRewardsResourceLocations(event.getPlayer().m_142081_())) {
                    Reward reward = RewardManager.get().getReward(collectRewardsResourceLocation);
                    storage.add(event.getPlayer().m_142081_(), reward.getResourceLocation(), reward.getOptions()[0]);
                }
                storage.getConfiguredPlayers().add(event.getPlayer().m_142081_());
                storage.m_77762_();
            }
            CompoundTag nbt = storage.serializeSimple();
            event.getPlayer().m_20194_().m_6846_().m_11314_().forEach(serverPlayerEntity -> NETWORK.get().sendTo((Object)new RewardSyncMessage(nbt), serverPlayerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        });
    }

    private void onServerStart(ServerStartingEvent event) {
        RewardCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
        RewardGrantCommand.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }
}

