/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.item;

import com.hrznstudio.titanium.energy.EnergyStorageItemStack;
import com.hrznstudio.titanium.item.BasicItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyItem
extends BasicItem {
    private final int capacity;
    private final int input;
    private final int output;

    public EnergyItem(String name, int capacity, int input, int output, Item.Properties properties) {
        super(name, properties.m_41487_(1));
        this.capacity = capacity;
        this.input = input;
        this.output = output;
    }

    public EnergyItem(String name, Item.Properties properties, int capacity, int throughput) {
        this(name, capacity, throughput, throughput, properties);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getInput() {
        return this.input;
    }

    public int getOutput() {
        return this.output;
    }

    @Override
    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == BasicItem.Key.SHIFT || super.hasTooltipDetails(key);
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, @Nonnull ItemStack stack, @Nonnull List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (key == BasicItem.Key.SHIFT) {
            // empty if block
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getEnergyStorage(stack).isPresent();
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(this.getEnergyStorage(stack).map(storage -> 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored()).orElse(0.0) * 13.0);
    }

    public int m_142159_(ItemStack stack) {
        return 15282738;
    }

    public LazyOptional<IEnergyStorage> getEnergyStorage(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityProvider(new EnergyStorageItemStack(stack, this.capacity, this.input, this.output));
    }

    public static class CapabilityProvider
    implements ICapabilityProvider {
        private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> energy);

        public CapabilityProvider(EnergyStorageItemStack energy) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityEnergy.ENERGY) {
                return this.energyCap.cast();
            }
            return LazyOptional.empty();
        }
    }
}

