/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.IRecipeSerializerReversed;
import com.hrznstudio.titanium.recipe.serializer.JSONSerializableDataHandler;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GenericSerializer<T extends SerializableRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<T>,
IRecipeSerializerReversed<T> {
    private final Class<T> recipeClass;
    private final RecipeType<T> recipeType;

    public GenericSerializer(RecipeType<T> recipeType, Class<T> recipeClass) {
        this.recipeType = recipeType;
        this.recipeClass = recipeClass;
    }

    public GenericSerializer(ResourceLocation resourceLocation, Class<T> recipeClass) {
        this(RecipeType.m_44119_((String)resourceLocation.toString()), recipeClass);
        this.setRegistryName(resourceLocation);
    }

    @Nonnull
    public T fromJson(@Nonnull ResourceLocation recipeId, JsonObject json) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Map.Entry entry : json.entrySet()) {
                if (!this.fieldExists((String)entry.getKey()) || !JSONSerializableDataHandler.acceptField(this.recipeClass.getField((String)entry.getKey()), this.recipeClass.getField((String)entry.getKey()).getType())) continue;
                this.recipeClass.getField((String)entry.getKey()).set(recipe, JSONSerializableDataHandler.read(this.recipeClass.getField((String)entry.getKey()).getType(), (JsonElement)entry.getValue()));
            }
            return (T)recipe;
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
            throw new JsonParseException((Throwable)e);
        }
    }

    public T fromJson(ResourceLocation recipeLoc, JsonObject recipeJson, ICondition.IContext context) {
        if (CraftingHelper.processConditions((JsonObject)recipeJson, (String)"conditions", (ICondition.IContext)context)) {
            return this.fromJson(recipeLoc, recipeJson);
        }
        return null;
    }

    @Override
    public JsonObject write(T recipe) {
        JsonObject object = new JsonObject();
        try {
            for (Field field : this.recipeClass.getFields()) {
                if (!JSONSerializableDataHandler.acceptField(field, field.getType())) continue;
                object.add(field.getName(), JSONSerializableDataHandler.write(field.getType(), field.get(recipe)));
            }
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
        }
        if (((SerializableRecipe)recipe).getOutputCondition() != null) {
            JsonObject recipeCondition = new JsonObject();
            recipeCondition.addProperty("type", "forge:conditional");
            JsonArray recipes = new JsonArray();
            JsonObject filteredRecipe = new JsonObject();
            JsonArray conditions = new JsonArray();
            conditions.add((JsonElement)((IConditionSerializer)((SerializableRecipe)recipe).getOutputCondition().getRight()).getJson((ICondition)((SerializableRecipe)recipe).getOutputCondition().getLeft()));
            filteredRecipe.add("conditions", (JsonElement)conditions);
            filteredRecipe.add("recipe", (JsonElement)object);
            recipes.add((JsonElement)filteredRecipe);
            recipeCondition.add("recipes", (JsonElement)recipes);
            return recipeCondition;
        }
        return object;
    }

    @ParametersAreNonnullByDefault
    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            SerializableRecipe recipe = (SerializableRecipe)this.recipeClass.getConstructor(ResourceLocation.class).newInstance(recipeId);
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.readField(field, field.getType(), buffer, recipe);
            }
            return (T)recipe;
        }
        catch (Exception e) {
            Titanium.LOGGER.error((Object)recipeId);
            Titanium.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    @ParametersAreNonnullByDefault
    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        try {
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.writeField(field, field.getType(), buffer, recipe);
            }
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
        }
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    private boolean fieldExists(String field) {
        for (Field recipeClassField : this.recipeClass.getFields()) {
            if (!recipeClassField.getName().equalsIgnoreCase(field)) continue;
            return true;
        }
        return false;
    }
}

