/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.internal;

import java.util.LinkedHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class MathHelper {
    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static double pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static LinkedHashSet<BlockPos> getBlocksAlongRay(Vec3 origin, Vec3 end) {
        return MathHelper.getBlocksAlongRay(origin, end, Integer.MAX_VALUE);
    }

    public static LinkedHashSet<BlockPos> getBlocksAlongRay(Vec3 origin, Vec3 end, int maxBlocks) {
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        if (maxBlocks == 0) {
            return positions;
        }
        if (origin.equals((Object)end)) {
            positions.add(new BlockPos(origin.f_82479_, origin.f_82480_, origin.f_82481_));
        } else {
            double endX = end.f_82479_;
            double endY = end.f_82480_;
            double endZ = end.f_82481_;
            double originX = origin.f_82479_;
            double originY = origin.f_82480_;
            double originZ = origin.f_82481_;
            int blockX = Mth.m_14107_((double)originX);
            int blockY = Mth.m_14107_((double)originY);
            int blockZ = Mth.m_14107_((double)originZ);
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(blockX, blockY, blockZ);
            positions.add(blockPos.m_7949_());
            double lengthX = endX - originX;
            double lengthY = endY - originY;
            double lengthZ = endZ - originZ;
            int signumX = Mth.m_14205_((double)lengthX);
            int signumY = Mth.m_14205_((double)lengthY);
            int signumZ = Mth.m_14205_((double)lengthZ);
            double stepSizeX = signumX == 0 ? Double.MAX_VALUE : (double)signumX / lengthX;
            double stepSizeY = signumY == 0 ? Double.MAX_VALUE : (double)signumY / lengthY;
            double stepSizeZ = signumZ == 0 ? Double.MAX_VALUE : (double)signumZ / lengthZ;
            double totalStepsX = stepSizeX * (signumX > 0 ? 1.0 - Mth.m_14185_((double)originX) : Mth.m_14185_((double)originX));
            double totalStepsY = stepSizeY * (signumY > 0 ? 1.0 - Mth.m_14185_((double)originY) : Mth.m_14185_((double)originY));
            double totalStepsZ = stepSizeZ * (signumZ > 0 ? 1.0 - Mth.m_14185_((double)originZ) : Mth.m_14185_((double)originZ));
            while ((totalStepsX <= 1.0 || totalStepsY <= 1.0 || totalStepsZ <= 1.0) && positions.size() != maxBlocks) {
                if (totalStepsX < totalStepsY) {
                    if (totalStepsX < totalStepsZ) {
                        blockX += signumX;
                        totalStepsX += stepSizeX;
                    } else {
                        blockZ += signumZ;
                        totalStepsZ += stepSizeZ;
                    }
                } else if (totalStepsY < totalStepsZ) {
                    blockY += signumY;
                    totalStepsY += stepSizeY;
                } else {
                    blockZ += signumZ;
                    totalStepsZ += stepSizeZ;
                }
                blockPos.m_122178_(blockX, blockY, blockZ);
                positions.add(blockPos.m_7949_());
            }
        }
        return positions;
    }
}

