/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import com.google.common.io.CharStreams;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import vazkii.psi.client.core.handler.ClientTickHandler;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.ConfigHandler;

public final class ShaderHandler {
    private static final int VERT_ST = 35633;
    private static final int FRAG_ST = 35632;
    public static boolean useShaders = false;
    private static final int VERT = 1;
    private static final int FRAG = 2;
    private static final String VERT_EXTENSION = ".vsh";
    private static final String FRAG_EXTENSION = ".fsh";
    public static int rawColor;
    public static int psiBar;
    public static int simpleBloom;

    public static void init() {
        useShaders = ShaderHandler.canUseShaders();
        if (!useShaders) {
            return;
        }
        Psi.logger.info("Initializing Psi shaders!");
        rawColor = ShaderHandler.createProgram("/assets/psi/shaders/raw_color", 2);
        psiBar = ShaderHandler.createProgram("/assets/psi/shaders/psi_bar", 2);
        simpleBloom = ShaderHandler.createProgram("/assets/psi/shaders/simple_bloom", 2);
    }

    public static void useShader(int shader, Consumer<Integer> callback) {
        if (!useShaders) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)ClientTickHandler.ticksInGame);
            if (callback != null) {
                callback.accept(shader);
            }
        }
    }

    public static void useShader(int shader) {
        ShaderHandler.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHandler.useShader(0);
    }

    public static boolean canUseShaders() {
        RenderSystem.m_187554_();
        return (Boolean)ConfigHandler.CLIENT.useShaders.get() != false && GL.getCapabilities().OpenGL14 && (GL.getCapabilities().GL_ARB_framebuffer_object || GL.getCapabilities().GL_EXT_framebuffer_object || GL.getCapabilities().OpenGL30) && (GL.getCapabilities().OpenGL21 || GL.getCapabilities().GL_ARB_fragment_shader && GL.getCapabilities().GL_ARB_fragment_shader && GL.getCapabilities().GL_ARB_shader_objects);
    }

    private static int createProgram(String s, int sides) {
        boolean vert = (sides & 1) != 0;
        boolean frag = (sides & 2) != 0;
        return ShaderHandler.createProgram(vert ? s + VERT_EXTENSION : null, frag ? s + FRAG_EXTENSION : null);
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHandler.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHandler.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            Psi.logger.error(ShaderHandler.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            Psi.logger.error(ShaderHandler.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHandler.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHandler.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    private static String readFileAsString(String filename) throws Exception {
        try (InputStream in = ShaderHandler.class.getResourceAsStream(filename);){
            if (in == null) {
                String string = "";
                return string;
            }
            String string = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            return string;
        }
    }
}

