/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class TextHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static List<String> renderText(int x, int y, int width, String unlocalizedText, boolean centered, boolean doit, Object ... format) {
        PoseStack matrixStack = new PoseStack();
        Font font = Minecraft.m_91087_().f_91062_;
        String text = I18n.m_118938_((String)unlocalizedText, (Object[])format);
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        for (String string : textEntries) {
            ArrayList<CallSite> words = new ArrayList<CallSite>();
            Object lineStr = "";
            String[] tokens = string.split(" ");
            for (String token : tokens) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = (String)lineStr + spaced;
                String controlCodes = TextHelper.toControlCodes(TextHelper.getControlCodes(prev));
                if (font.m_92895_((String)lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add((CallSite)((Object)(controlCodes + token)));
            }
            if (!((String)lineStr).isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        ArrayList<String> textLines = new ArrayList<String>();
        String lastLine = "";
        for (List list : lines) {
            list.size();
            int xi = x;
            int spacing = 4;
            StringBuilder lineStr = new StringBuilder();
            for (String s : list) {
                int extra = 0;
                int swidth = font.m_92895_(s);
                if (doit) {
                    if (centered) {
                        font.m_92883_(matrixStack, s, (float)(xi + width / 2 - swidth / 2), (float)y, 0xFFFFFF);
                    } else {
                        font.m_92883_(matrixStack, s, (float)xi, (float)y, 0xFFFFFF);
                    }
                }
                xi += swidth + spacing + extra;
                lineStr.append(s).append(" ");
            }
            if (lineStr.length() > 0 || lastLine.isEmpty()) {
                y += 10;
                textLines.add(lineStr.toString());
            }
            lastLine = lineStr.toString();
        }
        return textLines;
    }

    public static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    public static String toControlCodes(String s) {
        return s.replaceAll("(?i)[\\dA-FK-OR]", "\u00a7$0");
    }
}

