/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.IShapedRecipe;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.psi.client.patchouli.PatchouliUtils;
import vazkii.psi.common.Psi;

public class MultiCraftingProcessor
implements IComponentProcessor {
    private List<CraftingRecipe> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider variables) {
        Map recipeMap = Minecraft.m_91087_().f_91073_.m_7465_().m_44054_(RecipeType.f_44107_);
        List names = variables.get("recipes").asStream().map(IVariable::asString).collect(Collectors.toList());
        this.recipes = new ArrayList<CraftingRecipe>();
        for (String name : names) {
            Recipe recipe = (Recipe)recipeMap.get(new ResourceLocation(name));
            if (recipe != null) {
                this.recipes.add((CraftingRecipe)recipe);
                if (this.shapeless) {
                    this.shapeless = !(recipe instanceof IShapedRecipe);
                }
                for (Ingredient ingredient : recipe.m_7527_()) {
                    int size = ingredient.m_43908_().length;
                    if (this.longestIngredientSize >= size) continue;
                    this.longestIngredientSize = size;
                }
                continue;
            }
            Psi.logger.warn("Missing crafting recipe " + name);
        }
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!this.hasCustomHeading) {
                return IVariable.from((Object)this.recipes.get(0).m_8043_().m_41786_());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (CraftingRecipe recipe : this.recipes) {
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe shaped = (IShapedRecipe)recipe;
                    if (shaped.getRecipeWidth() < shapedX + 1) {
                        ingredients.add(Ingredient.f_43901_);
                        continue;
                    }
                    int realIndex = index - shapedY * (3 - shaped.getRecipeWidth());
                    NonNullList list = recipe.m_7527_();
                    ingredients.add(list.size() > realIndex ? (Ingredient)list.get(realIndex) : Ingredient.f_43901_);
                    continue;
                }
                NonNullList list = recipe.m_7527_();
                ingredients.add(list.size() > index ? (Ingredient)list.get(index) : Ingredient.f_43901_);
            }
            return PatchouliUtils.interweaveIngredients(ingredients, this.longestIngredientSize);
        }
        if (key.equals("output")) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(Recipe::m_8043_).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap((Boolean)this.shapeless);
        }
        return null;
    }
}

