/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalSword
extends SwordItem
implements IPsimetalTool {
    public ItemPsimetalSword(Item.Properties properties) {
        super((Tier)PsiAPI.PSIMETAL_TOOL_MATERIAL, 3, -2.4f, properties);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity target, @Nonnull LivingEntity attacker) {
        super.m_7579_(itemstack, target, attacker);
        if (this.isEnabled(itemstack) && attacker instanceof Player) {
            Player player = (Player)attacker;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            ItemStack playerCad = PsiAPI.getPlayerCAD(player);
            if (!playerCad.m_41619_()) {
                ItemStack bullet = ISocketable.socketable(itemstack).getSelectedBullet();
                ItemCAD.cast(player.m_20193_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                    context.attackedEntity = target;
                    context.tool = itemstack;
                });
            }
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)Attributes.f_22281_);
        }
        return modifiers;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.m_41776_()) {
            damage = stack.m_41773_();
        }
        super.setDamage(stack, damage);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (!this.isEnabled(stack)) {
            return 1.0f;
        }
        return super.m_8102_(stack, state);
    }

    @Nonnull
    public String m_5671_(ItemStack stack) {
        Object name = super.m_5671_(stack);
        if (!this.isEnabled(stack)) {
            name = (String)name + ".broken";
        }
        return name;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        Component componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
        tooltip.add((Component)new TranslatableComponent("psimisc.spell_selected", new Object[]{componentName}));
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return IPsimetalTool.super.initCapabilities(stack, nbt);
    }
}

