/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;

public class MessageSpellModified {
    private final BlockPos pos;
    private final Spell spell;

    public MessageSpellModified(BlockPos pos, Spell spell) {
        this.pos = pos;
        this.spell = spell;
    }

    public MessageSpellModified(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.spell = MessageSpellModified.readSpell(buf);
    }

    private static Spell readSpell(FriendlyByteBuf buf) {
        CompoundTag cmp = buf.m_130260_();
        return Spell.createFromNBT(cmp);
    }

    private static void writeSpell(FriendlyByteBuf buf, Spell spell) {
        CompoundTag cmp = new CompoundTag();
        if (spell != null) {
            spell.writeToNBT(cmp);
        }
        buf.m_130079_(cmp);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        MessageSpellModified.writeSpell(buf, this.spell);
    }

    public void receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            BlockEntity te = ((NetworkEvent.Context)context.get()).getSender().f_19853_.m_7702_(this.pos);
            if (te instanceof TileProgrammer) {
                TileProgrammer tile = (TileProgrammer)te;
                if (tile.playerLock == null || tile.playerLock.isEmpty() || tile.playerLock.equals(((NetworkEvent.Context)context.get()).getSender().m_7755_().getString())) {
                    tile.spell = this.spell;
                    tile.onSpellChanged();
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
                }
            }
        });
    }
}

