/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.common.block.base.DirectionBlockItemUseContext;
import vazkii.psi.common.block.base.ModBlocks;

public class PieceTrickPlaceBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> direction;

    public PieceTrickPlaceBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(8.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(8.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, true, false);
        this.addParam(this.direction);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 8);
        meta.addStat(EnumSpellStat.COST, 8);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 directionVal = this.getParamValue(context, this.direction);
        Direction facing = Direction.NORTH;
        Direction horizontalFacing = Direction.NORTH;
        if (directionVal != null) {
            facing = Direction.m_122366_((double)directionVal.x, (double)directionVal.y, (double)directionVal.z);
            horizontalFacing = Direction.m_122366_((double)directionVal.x, (double)0.0, (double)directionVal.z);
        }
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickPlaceBlock.placeBlock(context.caster, context.focalPoint.m_20193_(), pos, context.getTargetSlot(), false, facing, horizontalFacing);
        return null;
    }

    public static void placeBlock(Player player, Level world, BlockPos pos, int slot, boolean particles, Direction direction, Direction horizontalDirection) {
        PieceTrickPlaceBlock.placeBlock(player, world, pos, slot, particles, false, direction, horizontalDirection);
    }

    public static void placeBlock(Player player, Level world, BlockPos pos, int slot, boolean particles, boolean conjure, Direction direction, Direction horizontalDirection) {
        if (!world.m_46805_(pos) || !world.m_7966_(player, pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos), world.m_8055_(pos.m_142300_(Direction.UP)), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (state.m_60795_() || state.m_60767_().m_76336_() && !placeEvent.isCanceled()) {
            if (conjure) {
                world.m_46597_(pos, ModBlocks.conjured.m_49966_());
            } else {
                ItemStack stack = player.m_150109_().m_8020_(slot);
                if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem) {
                    ItemStack rem = PieceTrickPlaceBlock.removeFromInventory(player, stack, true);
                    BlockItem iblock = (BlockItem)rem.m_41720_();
                    BlockHitResult hit = new BlockHitResult(Vec3.f_82478_, direction, pos, false);
                    UseOnContext ctx = new UseOnContext(player, InteractionHand.MAIN_HAND, hit);
                    ItemStack save = player.m_21120_(ctx.m_43724_());
                    player.m_21008_(ctx.m_43724_(), rem);
                    UseOnContext newCtx = new UseOnContext(ctx.m_43723_(), ctx.m_43724_(), hit);
                    player.m_21008_(newCtx.m_43724_(), save);
                    InteractionResult result = iblock.m_40576_((BlockPlaceContext)new DirectionBlockItemUseContext(newCtx, horizontalDirection));
                    if (result != InteractionResult.FAIL) {
                        PieceTrickPlaceBlock.removeFromInventory(player, stack, false);
                        if (player.m_7500_()) {
                            HUDHandler.setRemaining(rem, -1);
                        } else {
                            HUDHandler.setRemaining(player, rem, null);
                        }
                    }
                }
            }
            if (particles) {
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)world.m_8055_(pos)));
            }
        }
    }

    public static ItemStack removeFromInventory(Player player, ItemStack stack, boolean copy) {
        if (player.m_7500_()) {
            return stack.m_41777_();
        }
        Inventory inv = player.m_150109_();
        for (int i = inv.m_6643_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.m_8020_(i);
            if (invStack.m_41619_() || !invStack.m_41656_(stack) || !ItemStack.m_41728_((ItemStack)stack, (ItemStack)invStack)) continue;
            ItemStack retStack = invStack.m_41777_();
            if (!copy) {
                invStack.m_41774_(1);
                if (invStack.m_41613_() == 0) {
                    inv.m_6836_(i, ItemStack.f_41583_);
                }
            }
            return retStack;
        }
        return ItemStack.f_41583_;
    }
}

