/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Map<WoodType, BlockFamily> CUSTOM_TEXTURE_WOOD_TYPES = Map.of(WoodType.f_61833_, BlockFamilies.f_175896_, WoodType.f_61832_, BlockFamilies.f_175907_, WoodType.f_61836_, BlockFamilies.f_175908_, WoodType.f_61835_, BlockFamilies.f_175911_, WoodType.f_61834_, BlockFamilies.f_175909_, WoodType.f_61830_, BlockFamilies.f_175910_, WoodType.f_61831_, BlockFamilies.f_175912_, WoodType.f_61837_, BlockFamilies.f_175913_);

    protected WoodStorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void addNameWoodAndTintData(ItemStack stack, BlockGetter level, BlockPos pos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)be));
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked()) {
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                CompoundTag storageContents = wbe.getStorageContentsTag();
                if (!storageContents.m_128456_()) {
                    ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                    NBTHelper.setUniqueId((ItemStack)stack, (String)"uuid", (UUID)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
                StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
            }
        }
    }

    private void addNameWoodAndTintData(ItemStack stack, WoodStorageBlockEntity wbe) {
        Item item = stack.m_41720_();
        if (item instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor > -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) > -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        if (wbe.m_8077_()) {
            stack.m_41714_(wbe.m_7770_());
        }
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> items.add((Object)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), woodType)));
        if (this.isBasicTier() || Boolean.TRUE.equals(Config.CLIENT.showHigherTierTintedVariants.get())) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack storageStack = new ItemStack((ItemLike)this);
                Item item = storageStack.m_41720_();
                if (item instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                    tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
                    tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.m_41068_()));
                }
                items.add((Object)storageStack);
            }
            ItemStack storageStack = new ItemStack((ItemLike)this);
            Item item = storageStack.m_41720_();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])DyeColor.YELLOW.m_41068_()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])DyeColor.LIME.m_41068_()));
            }
            items.add((Object)storageStack);
        }
    }

    private boolean isBasicTier() {
        return this == ModBlocks.BARREL.get() || this == ModBlocks.CHEST.get() || this == ModBlocks.LIMITED_BARREL_1.get() || this == ModBlocks.LIMITED_BARREL_2.get() || this == ModBlocks.LIMITED_BARREL_3.get() || this == ModBlocks.LIMITED_BARREL_4.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNameWoodAndTintData(stack, world, pos);
        return stack;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.m_142466_(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            WoodStorageBlockItem.getWoodType(stack).ifPresent(be::setWoodType);
            StorageBlockItem.getMainColorFromStack(stack).ifPresent(be.getStorageWrapper()::setMainColor);
            StorageBlockItem.getAccentColorFromStack(stack).ifPresent(be.getStorageWrapper()::setAccentColor);
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.m_21206_().m_41720_() == ModItems.STORAGE_TOOL.get()) {
                StorageToolItem.useOffHandOnPlaced(placer.m_21206_(), be);
            }
        });
    }

    protected boolean tryItemInteraction(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (stackInHand.m_41720_() == ModItems.PACKING_TAPE.get()) {
            WoodStorageBlockBase.packStorage(player, hand, b, stackInHand);
            return true;
        }
        return this.tryAddUpgrade(player, hand, b, stackInHand, facing, hitResult);
    }

    private static void packStorage(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        if (!player.m_7500_()) {
            stackInHand.m_41721_(stackInHand.m_41773_() + 1);
            if (stackInHand.m_41773_() >= stackInHand.m_41776_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
        b.setPacked(true);
        BlockState blockState = b.m_58900_();
        Block block = blockState.m_60734_();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            if (((Boolean)blockState.m_61143_((Property)StorageBlockBase.TICKING)).booleanValue()) {
                storageBlock.setTicking(player.f_19853_, b.m_58899_(), blockState, false);
            }
        }
        b.removeFromController();
        WorldHelper.notifyBlockUpdate((BlockEntity)b);
    }
}

