/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collection;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.ToolInfoOverlay;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedstorage.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ClientStorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ControllerRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LimitedBarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxDynamicModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.network.ScrolledToolMessage;
import net.p3pp3rf1y.sophisticatedstorage.network.StoragePacketHandler;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.compression.CompressionInventoryPart;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeContainer;

public class ClientEventHandler {
    private static final String KEYBIND_SOPHISTICATEDSTORAGE_CATEGORY = "keybind.sophisticatedstorage.category";
    private static final int MIDDLE_BUTTON = 2;
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(StorageTranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)StorageGuiKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.m_84895_(2), "keybind.sophisticatedstorage.category");
    private static final ResourceLocation CHEST_RL = new ResourceLocation("sophisticatedstorage", "chest");
    public static final ModelLayerLocation CHEST_LAYER = new ModelLayerLocation(CHEST_RL, "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ClientEventHandler::stitchTextures);
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::loadComplete);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::clientSetup);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ModParticles::registerFactories);
        modBus.addListener(ClientEventHandler::registerStorageLayerLoader);
        modBus.addListener(ClientEventHandler::onRegisterReloadListeners);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(ClientStorageContentsTooltip::onWorldLoad);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(EventPriority.HIGH, ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::onLimitedBarrelClicked);
        eventBus.addListener(ClientEventHandler::onMouseScrolled);
    }

    private static void onMouseScrolled(InputEvent.MouseScrollEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6144_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != ModItems.STORAGE_TOOL.get()) {
            return;
        }
        StoragePacketHandler.INSTANCE.sendToServer(new ScrolledToolMessage(evt.getScrollDelta() > 0.0));
        evt.setCanceled(true);
    }

    private static void onLimitedBarrelClicked(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getPlayer();
        if (!player.m_183503_().m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getWorld();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof LimitedBarrelBlock)) {
            return;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)block;
        if (limitedBarrel.isLookingAtFront(player, pos, state)) {
            if (player.m_7500_()) {
                event.setCanceled(true);
            } else if (player.getDigSpeed(state, event.getPos()) < 2.0f) {
                event.setUseItem(Event.Result.DENY);
                Minecraft.m_91087_().f_91072_.f_105195_ = 5;
            }
        }
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (SORT_KEYBIND.isActiveAndMatches(InputConstants.m_84827_((int)event.getKeyCode(), (int)event.getScanCode())) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static void registerStorageLayerLoader(AddPackFindersEvent event) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)resourceManager;
            reloadableResourceManager.m_7217_((PreparableReloadListener)StorageTextureManager.INSTANCE);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseClickedEvent.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(event.getButton());
        if (SORT_KEYBIND.isActiveAndMatches(input) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && (abstractContainerMenu = mc.f_91074_.f_36096_) instanceof StorageContainerMenu) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            StorageScreen screen;
            Slot selectedSlot;
            StorageContainerMenu container = (StorageContainerMenu)abstractContainerMenu;
            if (gui instanceof StorageScreen && (selectedSlot = (screen = (StorageScreen)gui).m_97744_(mouseX = (mh = mc.f_91067_).m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_(), mouseY = mh.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_())) != null && container.isNotPlayersInventorySlot(selectedSlot.f_40219_)) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void onModelRegistry(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)SophisticatedStorage.getRL("barrel"), (IModelLoader)BarrelDynamicModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SophisticatedStorage.getRL("limited_barrel"), (IModelLoader)LimitedBarrelDynamicModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SophisticatedStorage.getRL("chest"), (IModelLoader)ChestDynamicModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SophisticatedStorage.getRL("shulker_box"), (IModelLoader)ShulkerBoxDynamicModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ResourceLocation)SophisticatedStorage.getRL("simple_composite"), (IModelLoader)SimpleCompositeModel.Loader.INSTANCE);
        ClientEventHandler.addBarrelPartModelsToBake();
    }

    private static void addBarrelPartModelsToBake() {
        Collection models = Minecraft.m_91087_().m_91098_().m_6540_("models/block/barrel_part", fileName -> fileName.endsWith(".json"));
        models.forEach(modelName -> {
            if (modelName.m_135827_().equals("sophisticatedstorage")) {
                ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation(modelName.m_135827_(), modelName.m_135815_().substring("models/".length()).replace(".json", "")));
            }
        });
    }

    private static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            BarrelDynamicModelBase.invalidateCache();
            BarrelBakedModelBase.invalidateCache();
        }));
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CHEST_LAYER, () -> ChestRenderer.createSingleBodyLayer(true));
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.COPPER_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.IRON_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GOLD_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DIAMOND_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.NETHERITE_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_IRON_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_IRON_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_IRON_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_IRON_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_GOLD_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_GOLD_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_GOLD_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_GOLD_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_NETHERITE_BARREL_1.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_NETHERITE_BARREL_2.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_NETHERITE_BARREL_3.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.LIMITED_NETHERITE_BARREL_4.get()), (RenderType)RenderType.m_110463_());
        MinecraftForgeClient.registerTooltipComponentFactory(StorageContentsTooltip.class, ClientStorageContentsTooltip::new);
        event.enqueueWork(() -> ClientRegistry.registerKeyBinding((KeyMapping)SORT_KEYBIND));
        OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"storage_tool_info", (IIngameOverlay)ToolInfoOverlay.HUD_TOOL_INFO);
    }

    private static void stitchTextures(TextureStitchEvent.Pre event) {
        ClientEventHandler.stitchBlockAtlasTextures(event);
        ClientEventHandler.stitchChestTextures(event);
        ClientEventHandler.stitchShulkerBoxTextures(event);
        event.addSprite(LockRenderer.LOCK_TEXTURE.m_119203_());
        event.addSprite(LimitedBarrelRenderer.FILL_INDICATORS_TEXTURE.m_119203_());
        event.addSprite((ResourceLocation)CompressionInventoryPart.EMPTY_COMPRESSION_SLOT.getSecond());
        event.addSprite((ResourceLocation)HopperUpgradeContainer.EMPTY_INPUT_FILTER_SLOT_BACKGROUND.getSecond());
        event.addSprite((ResourceLocation)HopperUpgradeContainer.EMPTY_OUTPUT_FILTER_SLOT_BACKGROUND.getSecond());
    }

    private static void stitchShulkerBoxTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110735_)) {
            return;
        }
        event.addSprite(ShulkerBoxRenderer.BASE_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.COPPER_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.IRON_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.GOLD_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.DIAMOND_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.NETHERITE_TIER_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.TINTABLE_MAIN_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.TINTABLE_ACCENT_MATERIAL.m_119203_());
        event.addSprite(ShulkerBoxRenderer.NO_TINT_MATERIAL.m_119203_());
    }

    private static void stitchChestTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            return;
        }
        StorageTextureManager.INSTANCE.getUniqueChestMaterials().forEach(mat -> event.addSprite(mat.m_119203_()));
    }

    private static void stitchBlockAtlasTextures(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            return;
        }
        ChestDynamicModel.getWoodBreakTextures().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        event.addSprite(ChestDynamicModel.TINTABLE_BREAK_TEXTURE);
        event.addSprite(ShulkerBoxDynamicModel.TINTABLE_BREAK_TEXTURE);
        event.addSprite(ShulkerBoxDynamicModel.MAIN_BREAK_TEXTURE);
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get(), context -> new BarrelRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get(), context -> new LimitedBarrelRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get(), ChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get(), ShulkerBoxRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlocks.CONTROLLER_BLOCK_ENTITY_TYPE.get(), context -> new ControllerRenderer());
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ModItemColors.init();
            ModBlockColors.init();
        });
    }

    private static class StorageGuiKeyConflictContext
    implements IKeyConflictContext {
        public static final StorageGuiKeyConflictContext INSTANCE = new StorageGuiKeyConflictContext();

        private StorageGuiKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.m_91087_().f_91080_ instanceof StorageScreen;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

