/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.state.properties.WoodType;

public class StorageTextureManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final StorageTextureManager INSTANCE = new StorageTextureManager();
    private static final String PARENT_TAG = "parent";
    private static final String TYPE_TAG = "type";
    private static final String TEXTURES_TAG = "textures";
    private static final WoodType defaultChestWoodType = WoodType.f_61833_;
    private static final String CHEST_SUFFIX = "_chest";
    private static final Map<String, Supplier<ITextureParser>> TEXTURE_PARSERS = new HashMap<String, Supplier<ITextureParser>>();
    private final Map<WoodType, Map<ChestMaterial, Material>> woodChestMaterials = new HashMap<WoodType, Map<ChestMaterial, Material>>();

    private StorageTextureManager() {
        super(GSON, "storage_texture_definitions");
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.clear();
        Map fileContents = super.m_5944_(pResourceManager, pProfiler);
        HashMap<ResourceLocation, StorageTextureDefinition> storageTextureDefinitions = new HashMap<ResourceLocation, StorageTextureDefinition>();
        fileContents.forEach((resourceLocation, json) -> this.loadDefinition((Map<ResourceLocation, StorageTextureDefinition>)storageTextureDefinitions, (ResourceLocation)resourceLocation, (JsonElement)json, fileContents));
        storageTextureDefinitions.forEach((fileName, definition) -> {
            String type = definition.getType();
            String filePath = fileName.m_135815_();
            if (type.equals("chest") && filePath.endsWith(CHEST_SUFFIX)) {
                WoodType.m_61843_().filter(wt -> wt.m_61846_().equals(filePath.substring(0, filePath.lastIndexOf(CHEST_SUFFIX)))).findFirst().ifPresent(wt -> {
                    EnumMap chestMaterials = new EnumMap(ChestMaterial.class);
                    definition.getTextures().forEach((textureName, rl) -> ChestMaterial.fromString(textureName).ifPresent(cm -> chestMaterials.put((ChestMaterial)((Object)((Object)((Object)cm))), new Material(Sheets.f_110740_, rl))));
                    this.woodChestMaterials.put((WoodType)wt, chestMaterials);
                });
            }
        });
        return fileContents;
    }

    private void clear() {
        this.woodChestMaterials.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
    }

    @Nullable
    public Map<ChestMaterial, Material> getWoodChestMaterials(WoodType woodType) {
        return this.woodChestMaterials.getOrDefault(woodType, this.woodChestMaterials.get(defaultChestWoodType));
    }

    private Optional<StorageTextureDefinition> loadDefinition(Map<ResourceLocation, StorageTextureDefinition> storageTextureDefinitions, ResourceLocation resourceLocation, JsonElement json, Map<ResourceLocation, JsonElement> fileContents) {
        JsonElement parentJson;
        ResourceLocation parent;
        if (storageTextureDefinitions.containsKey(resourceLocation)) {
            return Optional.of(storageTextureDefinitions.get(resourceLocation));
        }
        if (!json.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject jsonContents = json.getAsJsonObject();
        String type = "";
        StorageTextureDefinition parentDefinition = null;
        if (jsonContents.has(PARENT_TAG) && jsonContents.get(PARENT_TAG).isJsonPrimitive() && (parentDefinition = (StorageTextureDefinition)this.loadDefinition(storageTextureDefinitions, parent = new ResourceLocation(jsonContents.get(PARENT_TAG).getAsString()), parentJson = fileContents.get(parent), fileContents).orElse(null)) != null) {
            type = parentDefinition.getType();
        }
        if (jsonContents.has(TYPE_TAG) && jsonContents.get(TYPE_TAG).isJsonPrimitive()) {
            type = jsonContents.get(TYPE_TAG).getAsString();
        }
        if (!TEXTURE_PARSERS.containsKey(type)) {
            return Optional.empty();
        }
        ITextureParser textureParser = TEXTURE_PARSERS.get(type).get();
        if (parentDefinition != null) {
            textureParser.copyFromParentDefinition(parentDefinition);
        }
        Optional<StorageTextureDefinition> result = textureParser.parseDefinition(type, jsonContents);
        result.ifPresent(def -> storageTextureDefinitions.put(resourceLocation, (StorageTextureDefinition)def));
        return result;
    }

    public Collection<Material> getUniqueChestMaterials() {
        HashSet<Material> uniqueMaterials = new HashSet<Material>();
        this.woodChestMaterials.values().forEach(chestMaterials -> uniqueMaterials.addAll(chestMaterials.values()));
        return uniqueMaterials;
    }

    static {
        TEXTURE_PARSERS.put("chest", ChestTextureParser::new);
    }

    public static class StorageTextureDefinition {
        private static final String ALL_SIDES_TEXTURES = "allSides";
        private final String type;
        private final Map<String, Map<String, ResourceLocation>> textures;

        public StorageTextureDefinition(String type, Map<String, Map<String, ResourceLocation>> multiplePartTextures, boolean multipleTextureIgnoredParameter) {
            this.type = type;
            this.textures = multiplePartTextures;
        }

        public StorageTextureDefinition(String type, Map<String, ResourceLocation> textures) {
            this.type = type;
            this.textures = new HashMap<String, Map<String, ResourceLocation>>();
            this.textures.put(ALL_SIDES_TEXTURES, textures);
        }

        public String getType() {
            return this.type;
        }

        public Map<String, ResourceLocation> getTextures() {
            return this.textures.getOrDefault(ALL_SIDES_TEXTURES, new HashMap());
        }
    }

    private static interface ITextureParser {
        public void copyFromParentDefinition(StorageTextureDefinition var1);

        public Optional<StorageTextureDefinition> parseDefinition(String var1, JsonObject var2);
    }

    public static enum ChestMaterial {
        BASE,
        WOOD_TIER,
        COPPER_TIER,
        IRON_TIER,
        GOLD_TIER,
        DIAMOND_TIER,
        NETHERITE_TIER,
        TINTABLE_MAIN,
        TINTABLE_ACCENT,
        PACKED;


        public static Optional<ChestMaterial> fromString(String materialName) {
            for (ChestMaterial value : ChestMaterial.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(materialName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    private static class ChestTextureParser
    implements ITextureParser {
        private final Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();

        private ChestTextureParser() {
        }

        @Override
        public void copyFromParentDefinition(StorageTextureDefinition parentDefinition) {
            this.textures.putAll(parentDefinition.getTextures());
        }

        @Override
        public Optional<StorageTextureDefinition> parseDefinition(String type, JsonObject jsonContents) {
            if (jsonContents.has(StorageTextureManager.TEXTURES_TAG) && jsonContents.get(StorageTextureManager.TEXTURES_TAG).isJsonObject()) {
                JsonObject jsonTextures = jsonContents.get(StorageTextureManager.TEXTURES_TAG).getAsJsonObject();
                jsonTextures.keySet().forEach(name -> {
                    if (jsonTextures.get(name).isJsonPrimitive()) {
                        this.textures.put((String)name, new ResourceLocation(jsonTextures.get(name).getAsString()));
                    }
                });
            }
            return Optional.of(new StorageTextureDefinition(type, this.textures));
        }
    }
}

