/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class SmithingStorageUpgradeRecipe
extends UpgradeRecipe
implements IWrapperRecipe<UpgradeRecipe> {
    public static final Serializer SERIALIZER = new Serializer();
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final UpgradeRecipe compose;

    public SmithingStorageUpgradeRecipe(UpgradeRecipe compose) {
        super(compose.m_6423_(), compose.f_44518_, compose.f_44519_, compose.m_8043_());
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        return super.m_5818_(pInv, pLevel) && this.getStorage(pInv).map(storage -> !(storage.m_41720_() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack upgradedStorage = this.getCraftingResult().m_41777_();
        this.getStorage(inv).ifPresent(storage -> upgradedStorage.m_41751_(storage.m_41783_()));
        return upgradedStorage;
    }

    private ItemStack getCraftingResult() {
        return Objects.requireNonNull((ItemStack)ObfuscationReflectionHelper.getPrivateValue(UpgradeRecipe.class, (Object)((Object)this), (String)"f_44520_"));
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getStorage(Container inv) {
        BlockItem blockItem;
        ItemStack slotStack = inv.m_8020_(0);
        Item item = slotStack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof IStorageBlock) {
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public Serializer getSerializer() {
        return SERIALIZER;
    }

    public UpgradeRecipe getCompose() {
        return this.compose;
    }

    public static class Serializer
    extends RecipeWrapperSerializer<UpgradeRecipe, SmithingStorageUpgradeRecipe> {
        public Serializer() {
            super(SmithingStorageUpgradeRecipe::new, RecipeSerializer.f_44096_);
        }
    }
}

