/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    private static final String FLAT_TOP_TAG = "flatTop";
    private static final String MATERIALS_TAG = "materials";

    public BarrelBlockItem(Block block) {
        this(block, new Item.Properties());
    }

    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(ItemStack stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop(stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(ItemStack stack, boolean flatTop) {
        if (flatTop) {
            NBTHelper.setBoolean((ItemStack)stack, (String)FLAT_TOP_TAG, (boolean)true);
        } else {
            NBTHelper.removeTag((ItemStack)stack, (String)FLAT_TOP_TAG);
        }
    }

    public static boolean isFlatTop(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)FLAT_TOP_TAG).orElse(false);
    }

    public static void setMaterials(ItemStack barrel, Map<BarrelMaterial, ResourceLocation> materials) {
        NBTHelper.putMap((CompoundTag)barrel.m_41784_(), (String)MATERIALS_TAG, materials, BarrelMaterial::m_7912_, resourceLocation -> StringTag.m_129297_((String)resourceLocation.toString()));
    }

    public static Map<BarrelMaterial, ResourceLocation> getMaterials(ItemStack barrel) {
        return NBTHelper.getMap((ItemStack)barrel, (String)MATERIALS_TAG, BarrelMaterial::fromName, (bm, tag) -> Optional.of(new ResourceLocation(tag.m_7916_()))).orElse(Map.of());
    }

    public static void removeMaterials(ItemStack stack) {
        NBTHelper.removeTag((ItemStack)stack, (String)MATERIALS_TAG);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        Component name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.m_7626_(stack) : BarrelBlockItem.getDisplayName(this.m_5524_(), null);
        if (BarrelBlockItem.isFlatTop(stack)) {
            return name.m_6881_().m_7220_((Component)new TranslatableComponent(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top"));
        }
        return name;
    }

    @Override
    public boolean isTintable(ItemStack stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

