/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CompressionUpgradeConfig {
    private static final String DECOMPRESSIBLE_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)=(\\d+)x([a-z0-9_.-]+:[a-z0-9_/.-]+)";
    public final ForgeConfigSpec.IntValue maxNumberOfSlots;
    public final ForgeConfigSpec.ConfigValue<List<String>> additionalDecompressibleItems;
    @Nullable
    private Map<Item, RecipeHelper.UncompactingResult> additionalDecompressibleItemsMap = null;

    public CompressionUpgradeConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Compression Upgrade Settings").push("compressionUpgrade");
        this.maxNumberOfSlots = builder.comment("Defines how many slots at a maximum compression upgrade is able to use").defineInRange("maxNumberOfSlots", 5, 3, 9);
        this.additionalDecompressibleItems = builder.comment("List of items that can be decompressed by compression upgrade and their results. Item registry names are expected here in format of \"mod:itemBeingDecompressed=Nxmod:itemDecompressResult").define("additionalDecompressibleItems", CompressionUpgradeConfig.getDecompressibleItemsDefault(), entries -> {
            List decompressibleItems = (List)entries;
            return decompressibleItems != null && decompressibleItems.stream().allMatch(itemName -> itemName.matches(DECOMPRESSIBLE_MATCHER));
        });
        builder.pop();
    }

    @Nonnull
    private static List<String> getDecompressibleItemsDefault() {
        return List.of(CompressionUpgradeConfig.getDecompressibleEntry(Items.f_42054_, 4, Items.f_42525_), CompressionUpgradeConfig.getDecompressibleEntry(Items.f_42157_, 4, Items.f_42692_));
    }

    private static String getDecompressibleEntry(Item fromItem, int count, Item toItem) {
        return fromItem.getRegistryName().toString() + "=" + count + "x" + toItem.getRegistryName().toString();
    }

    public Optional<RecipeHelper.UncompactingResult> getDecompressionResult(Item item) {
        if (this.additionalDecompressibleItemsMap == null) {
            this.additionalDecompressibleItemsMap = new HashMap<Item, RecipeHelper.UncompactingResult>();
            Pattern pattern = Pattern.compile(DECOMPRESSIBLE_MATCHER);
            ((List)this.additionalDecompressibleItems.get()).forEach(decompressibleItem -> {
                Matcher matcher = pattern.matcher((CharSequence)decompressibleItem);
                if (matcher.find()) {
                    Item fromItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matcher.group(1)));
                    int count = Integer.parseInt(matcher.group(2));
                    Item toItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(matcher.group(3)));
                    if (fromItem != null && toItem != null && (count == 4 || count == 9)) {
                        this.additionalDecompressibleItemsMap.put(fromItem, new RecipeHelper.UncompactingResult(toItem, count == 4 ? RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE : RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE));
                    }
                }
            });
        }
        return Optional.ofNullable(this.additionalDecompressibleItemsMap.get(item));
    }

    public void clearCache() {
        this.additionalDecompressibleItemsMap = null;
    }
}

