/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IceSheetBlock
extends MultifaceBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty GLOWING = BlockStateProperties.f_61443_;
    public static final IntegerProperty GROWTH_DISTANCE = BlockStateProperties.f_61407_;

    public IceSheetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GROWTH_DISTANCE, (Comparable)Integer.valueOf(0)));
    }

    public void m_7455_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        if (random.nextFloat() < 0.25f && serverLevel.m_45517_(LightLayer.BLOCK, blockPos) > 12 - blockState.m_60739_((BlockGetter)serverLevel, blockPos)) {
            serverLevel.m_7471_(blockPos, false);
        }
        if (random.nextFloat() < 0.05f) {
            this.spreadFromRandomFaceWithinBlock(blockState, serverLevel, blockPos, random);
            if ((Integer)blockState.m_61143_((Property)GROWTH_DISTANCE) > 0) {
                this.m_153935_(blockState, serverLevel, blockPos, random);
            }
        }
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos blockPos, Random random) {
        if (level.m_45517_(LightLayer.BLOCK, blockPos) <= 12 - blockState.m_60739_((BlockGetter)level, blockPos) || random.nextFloat() < 0.2f) {
            // empty if block
        }
    }

    public BlockState m_7417_(BlockState thisState, Direction directionToNeighbor, BlockState neighborState, LevelAccessor levelAccessor, BlockPos thisPos, BlockPos neighborPos) {
        if (((Boolean)thisState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(thisPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(thisState, directionToNeighbor, neighborState, levelAccessor, thisPos, neighborPos);
    }

    public BlockState m_153940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Direction neighborDirection) {
        BlockState updatedState;
        if (!this.m_153920_(neighborDirection)) {
            return null;
        }
        BlockPos neighborPos = blockPos.m_142300_(neighborDirection);
        if (blockState.m_60713_((Block)this)) {
            updatedState = blockState;
        } else {
            BlockState blockState2 = updatedState = blockState.m_60819_().m_164512_((Fluid)Fluids.f_76193_) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : this.m_49966_();
        }
        if (IceSheetBlock.m_153829_(blockGetter, neighborDirection, neighborPos, blockGetter.m_8055_(neighborPos))) {
            updatedState = (BlockState)updatedState.m_61124_((Property)IceSheetBlock.m_153933_((Direction)neighborDirection), (Comparable)Boolean.valueOf(true));
            Block adjacentBlock = blockGetter.m_8055_(neighborPos).m_60734_();
            if (adjacentBlock instanceof OreBlock || adjacentBlock instanceof RedStoneOreBlock) {
                updatedState = (BlockState)updatedState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true));
            }
        } else {
            updatedState = null;
        }
        return updatedState;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean bl) {
        if (level.f_46443_) {
            return;
        }
        for (Map.Entry entry : PipeBlock.f_55154_.entrySet()) {
            BlockPos adjacentPos;
            Block adjacentBlock;
            boolean isAdjacentBlockOre;
            Direction direction = (Direction)entry.getKey();
            BooleanProperty property = (BooleanProperty)entry.getValue();
            if (!((Boolean)blockState.m_61143_((Property)property)).booleanValue() || !(isAdjacentBlockOre = (adjacentBlock = level.m_8055_(adjacentPos = blockPos.m_142300_(direction)).m_60734_()) instanceof OreBlock || adjacentBlock instanceof RedStoneOreBlock)) continue;
            if (!((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue()) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 2);
            }
            return;
        }
        if (((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public FluidState m_5888_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{GLOWING, WATERLOGGED, GROWTH_DISTANCE});
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    private static boolean m_153829_(BlockGetter blockGetter, Direction direction, BlockPos blockPos, BlockState blockState) {
        return Block.m_49918_((VoxelShape)blockState.m_60812_(blockGetter, blockPos), (Direction)direction.m_122424_());
    }

    public boolean spreadFromRandomFaceWithinBlock(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        List possibleSourceDirections = Lists.newArrayList((Object[])f_153806_).stream().filter(direction -> IceSheetBlock.m_153900_(blockState, direction)).collect(Collectors.toList());
        Collections.shuffle(possibleSourceDirections);
        for (Direction possibleSourceDirection : possibleSourceDirections) {
            List possibleTargetDirections = Lists.newArrayList((Object[])f_153806_).stream().filter(direction -> direction.m_122434_() != possibleSourceDirection.m_122434_() && (Boolean)blockState.m_61143_((Property)IceSheetBlock.m_153933_((Direction)direction)) == false).collect(Collectors.toList());
            Collections.shuffle(possibleTargetDirections);
            for (Direction targetDirection : possibleTargetDirections) {
                BlockPos neighborPos;
                if (!IceSheetBlock.m_153829_((BlockGetter)serverLevel, targetDirection, neighborPos = blockPos.m_142300_(targetDirection), serverLevel.m_8055_(neighborPos))) continue;
                BlockState updatedState = (BlockState)blockState.m_61124_((Property)IceSheetBlock.m_153933_((Direction)targetDirection), (Comparable)Boolean.valueOf(true));
                Block adjacentBlock = serverLevel.m_8055_(neighborPos).m_60734_();
                if (adjacentBlock instanceof OreBlock || adjacentBlock instanceof RedStoneOreBlock) {
                    updatedState = (BlockState)updatedState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true));
                }
                serverLevel.m_7731_(blockPos, updatedState, 2);
                return true;
            }
        }
        return false;
    }

    public boolean m_153935_(BlockState spreadOriginBlockState, ServerLevel serverLevel, BlockPos spreadOriginBlockPos, Random random) {
        ArrayList directions = Lists.newArrayList((Object[])f_153806_);
        Collections.shuffle(directions);
        return directions.stream().filter(direction -> IceSheetBlock.m_153900_(spreadOriginBlockState, direction)).anyMatch(direction -> this.m_153873_(spreadOriginBlockState, (LevelAccessor)serverLevel, spreadOriginBlockPos, (Direction)direction, random, false));
    }

    public boolean m_153873_(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, Random random, boolean bl) {
        List<Direction> list = Arrays.asList(f_153806_);
        Collections.shuffle(list, random);
        return list.stream().anyMatch(targetDirection -> this.m_153866_(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, (Direction)targetDirection, bl));
    }

    public boolean m_153866_(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, Direction targetDirection, boolean bl) {
        Optional<Pair<BlockPos, Direction>> optional = this.getSpreadFromFaceTowardDirection(spreadOriginBlockState, levelAccessor, spreadOriginBlockPos, faceDirection, targetDirection);
        if (optional.isPresent()) {
            Pair<BlockPos, Direction> pair = optional.get();
            return this.spreadToFace(levelAccessor, (BlockPos)pair.getFirst(), (Direction)pair.getSecond(), bl, spreadOriginBlockState);
        }
        return false;
    }

    private Optional<Pair<BlockPos, Direction>> getSpreadFromFaceTowardDirection(BlockState spreadOriginBlockState, LevelAccessor levelAccessor, BlockPos spreadOriginBlockPos, Direction faceDirection, Direction targetDirection) {
        if (targetDirection.m_122434_() != faceDirection.m_122434_() && IceSheetBlock.m_153900_(spreadOriginBlockState, faceDirection) && !IceSheetBlock.m_153900_(spreadOriginBlockState, targetDirection)) {
            Direction direction3;
            if (this.canSpreadToFace(levelAccessor, spreadOriginBlockPos, targetDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)spreadOriginBlockPos, (Object)targetDirection));
            }
            BlockPos blockPos2 = spreadOriginBlockPos.m_142300_(targetDirection);
            if (this.canSpreadToFace(levelAccessor, blockPos2, faceDirection, spreadOriginBlockState)) {
                return Optional.of(Pair.of((Object)blockPos2, (Object)faceDirection));
            }
            BlockPos blockPos3 = blockPos2.m_142300_(faceDirection);
            return this.canSpreadToFace(levelAccessor, blockPos3, direction3 = targetDirection.m_122424_(), spreadOriginBlockState) ? Optional.of(Pair.of((Object)blockPos3, (Object)direction3)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean canSpreadToFace(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction, BlockState spreadOriginBlockState) {
        BlockState blockState = levelAccessor.m_8055_(blockPos);
        if (!this.canSpreadInto(levelAccessor, blockState, blockPos, spreadOriginBlockState)) {
            return false;
        }
        BlockState blockState2 = this.m_153940_(blockState, (BlockGetter)levelAccessor, blockPos, direction);
        return blockState2 != null;
    }

    private boolean spreadToFace(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction, boolean bl, BlockState spreadOriginBlockState) {
        if (!spreadOriginBlockState.m_61138_((Property)GROWTH_DISTANCE)) {
            return false;
        }
        BlockState oldBlockState = levelAccessor.m_8055_(blockPos);
        BlockState newBlockState = this.m_153940_(oldBlockState, (BlockGetter)levelAccessor, blockPos, direction);
        if (newBlockState != null) {
            newBlockState = (BlockState)newBlockState.m_61124_((Property)GROWTH_DISTANCE, (Comparable)Integer.valueOf((Integer)spreadOriginBlockState.m_61143_((Property)GROWTH_DISTANCE) - 1));
            if (bl) {
                levelAccessor.m_46865_(blockPos).m_8113_(blockPos);
            }
            return levelAccessor.m_7731_(blockPos, newBlockState, 2);
        }
        return false;
    }

    private boolean canSpreadInto(LevelAccessor levelAccessor, BlockState blockState, BlockPos blockPos, BlockState spreadOriginBlockState) {
        return (blockState.m_60795_() || blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)GROWTH_DISTANCE) < (Integer)spreadOriginBlockState.m_61143_((Property)GROWTH_DISTANCE) || blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76170_()) && levelAccessor.m_45517_(LightLayer.BLOCK, blockPos) <= 12 - blockState.m_60739_((BlockGetter)levelAccessor, blockPos);
    }

    private static boolean m_153900_(BlockState blockState, Direction direction) {
        BooleanProperty booleanProperty = IceSheetBlock.m_153933_((Direction)direction);
        return blockState.m_61138_((Property)booleanProperty) && (Boolean)blockState.m_61143_((Property)booleanProperty) != false;
    }
}

