/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.particle;

import com.yungnickyoung.minecraft.yungscavebiomes.block.BrittleSandstoneBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class FallingAncientDustParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private final SpriteSet sprites;

    FallingAncientDustParticle(ClientLevel clientLevel, double xo, double yo, double zo, float r, float g, float b, SpriteSet spriteSet) {
        super(clientLevel, xo, yo, zo);
        this.sprites = spriteSet;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        int k = Mth.m_144928_((Random)clientLevel.m_5822_(), (int)256, (int)512);
        this.f_107225_ = (int)Math.max((float)k, 1.0f);
        this.f_107224_ = Mth.m_144928_((Random)clientLevel.m_5822_(), (int)0, (int)96);
        this.m_108339_(spriteSet);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float f) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + f) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.m_108339_(this.sprites);
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.f_107218_) {
            this.f_107231_ = 0.0f;
            this.f_107204_ = 0.0f;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107216_ -= (double)0.003f;
        this.f_107216_ = Math.max(this.f_107216_, (double)-0.14f);
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(BlockParticleOption blockParticleOption, ClientLevel clientLevel, double xo, double yo, double zo, double dx, double dy, double dz) {
            BlockState blockState = blockParticleOption.m_123642_();
            if (!blockState.m_60795_() && blockState.m_60799_() == RenderShape.INVISIBLE) {
                return null;
            }
            BlockPos blockPos = new BlockPos(xo, yo, zo);
            int color = Minecraft.m_91087_().m_91298_().m_92582_(blockState, (Level)clientLevel, blockPos);
            if (blockState.m_60734_() instanceof BrittleSandstoneBlock) {
                color = ((BrittleSandstoneBlock)blockState.m_60734_()).getDustColor();
            }
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new FallingAncientDustParticle(clientLevel, xo, yo, zo, r, g, b, this.sprite);
        }
    }
}

