/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.frosted_caves;

import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.PotionModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownPotion.class})
public abstract class MixinThrownPotion
extends ThrowableItemProjectile {
    public MixinThrownPotion(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ThrownPotion;discard()V", ordinal=0)})
    protected void yungscavebiomes_onFrostSplashPotionHit(HitResult hitResult, CallbackInfo ci) {
        ItemStack itemStack;
        Potion potion;
        if (!(this.f_19853_.f_46443_ || this.f_19853_.m_6042_().m_63951_() || (potion = PotionUtils.m_43579_((ItemStack)(itemStack = this.m_7846_()))) != PotionModule.FROST_POTION.get() && potion != PotionModule.STRONG_FROST_POTION.get())) {
            BlockPos originPos = null;
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                originPos = ((BlockHitResult)hitResult).m_82425_();
            } else if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                originPos = ((EntityHitResult)hitResult).m_82443_().m_20097_();
            }
            if (originPos == null) {
                return;
            }
            BlockPos.MutableBlockPos currPos = originPos.m_122032_();
            BlockPos.MutableBlockPos mutable = currPos.m_122032_();
            int attemptDistance = potion == PotionModule.FROST_POTION.get() ? 3 : 4;
            int maxDist = potion == PotionModule.FROST_POTION.get() ? 8 : 14;
            for (int x = -attemptDistance; x <= attemptDistance; ++x) {
                for (int y = -attemptDistance; y <= attemptDistance; ++y) {
                    for (int z = -attemptDistance; z <= attemptDistance; ++z) {
                        if (x * x + y * y + z * z > maxDist) continue;
                        currPos.m_122154_((Vec3i)originPos, x, y, z);
                        BlockState currState = this.f_19853_.m_8055_((BlockPos)currPos);
                        if (!currState.m_60795_() && !currState.m_60713_(Blocks.f_49990_) && !currState.m_204336_(BlockTags.f_198158_)) continue;
                        for (Direction direction : Direction.values()) {
                            mutable.m_122159_((Vec3i)currPos, direction);
                            IceSheetBlock iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get());
                            BlockState updatedBlockState = iceSheetBlock.m_153940_(currState, (BlockGetter)this.f_19853_, (BlockPos)currPos, direction);
                            if (updatedBlockState == null) continue;
                            currState = updatedBlockState = (BlockState)updatedBlockState.m_61124_((Property)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(0));
                            this.f_19853_.m_7731_((BlockPos)currPos, updatedBlockState, 3);
                        }
                    }
                }
            }
        }
    }
}

