/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.module;

import com.yungnickyoung.minecraft.yungscavebiomes.network.IcicleShatterS2CPacket;
import com.yungnickyoung.minecraft.yungscavebiomes.network.SandstormSyncS2CPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkModuleForge {
    private static final String PROTOCOL_VERSION = "1.0";
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(NetworkModuleForge::commonSetup);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("yungscavebiomes", "messages")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
            INSTANCE.messageBuilder(IcicleShatterS2CPacket.class, NetworkModuleForge.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(IcicleShatterS2CPacket::new).encoder(IcicleShatterS2CPacket::toBytes).consumer(IcicleShatterS2CPacket::handle).add();
            INSTANCE.messageBuilder(SandstormSyncS2CPacket.class, NetworkModuleForge.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SandstormSyncS2CPacket::new).encoder(SandstormSyncS2CPacket::toBytes).consumer(SandstormSyncS2CPacket::handle).add();
        });
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToClient(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToClientsTrackingChunk(MSG message, LevelChunk chunk) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), message);
    }

    public static <MSG> void sendToClientsInLevel(MSG message, ResourceKey<Level> levelResourceKey) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> levelResourceKey), message);
    }

    static {
        packetId = 0;
    }
}

