/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.sandstorm;

import com.google.common.hash.Hashing;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.ServerLevelAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.CriteriaModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.SavedData;

public class SandstormServerData
extends SavedData {
    private static final int SYNC_INTERVAL = 60;
    private final ServerLevel serverLevel;
    private int timeSinceSync;
    private boolean isSandstormActive = false;
    private int currSandstormTicks;
    private int cooldownTicks;
    private int totalSandstormDurationTicks;
    private int totalSandstormCooldownTicks;
    private long sandstormSeed;

    public SandstormServerData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.resetSandstormTimeAndTotalDuration();
        this.resetSandstormCooldownAndTotalCoolDown();
        this.m_77762_();
    }

    public SandstormServerData(ServerLevel serverLevel, CompoundTag compoundTag) {
        this(serverLevel);
        this.isSandstormActive = compoundTag.m_128471_("isSandstormActive");
        this.sandstormSeed = compoundTag.m_128454_("sandstormSeed");
        this.currSandstormTicks = compoundTag.m_128451_("sandstormTime");
        this.cooldownTicks = compoundTag.m_128451_("sandstormCooldown");
        this.totalSandstormDurationTicks = compoundTag.m_128451_("totalSandstormDuration");
        this.totalSandstormCooldownTicks = compoundTag.m_128451_("totalSandstormCooldown");
    }

    public void start() {
        YungsCaveBiomesCommon.LOGGER.debug("Starting sandstorm in {}", (Object)this.serverLevel.m_46472_().m_135782_());
        this.resetSandstormTimeAndTotalDuration();
        this.sandstormSeed = Hashing.sha256().hashLong(this.sandstormSeed + ((ServerLevelAccessor)this.serverLevel).getServerLevelData().m_6793_()).asLong();
        this.isSandstormActive = true;
        this.syncToClients();
    }

    public void stop() {
        YungsCaveBiomesCommon.LOGGER.debug("STOPPING SANDSTORM in {}", (Object)this.serverLevel.m_46472_().m_135782_());
        this.resetSandstormCooldownAndTotalCoolDown();
        this.isSandstormActive = false;
        this.serverLevel.m_6907_().forEach(player -> {
            if (!player.m_5833_() && this.serverLevel.m_204166_(player.m_142538_()).m_203565_(BiomeModule.LOST_CAVES.getResourceKey())) {
                CriteriaModule.SANDSTORM_END.trigger((ServerPlayer)player);
            }
        });
        this.syncToClients();
    }

    public void tick() {
        if (YungsCaveBiomesCommon.DEBUG_LOG) {
            YungsCaveBiomesCommon.LOGGER.info("Sandstorm {} >> {} / {} time, {} / {} cooldown", (Object)this.serverLevel.m_46472_().m_135782_(), (Object)this.currSandstormTicks, (Object)this.totalSandstormDurationTicks, (Object)this.cooldownTicks, (Object)this.totalSandstormCooldownTicks);
        }
        ++this.timeSinceSync;
        if (this.isSandstormActive) {
            --this.currSandstormTicks;
            if (this.currSandstormTicks <= 0) {
                this.stop();
            }
        } else {
            --this.cooldownTicks;
            if (this.cooldownTicks <= 0) {
                this.start();
            }
        }
        if (this.timeSinceSync > 60) {
            this.syncToClients();
            if (YungsCaveBiomesCommon.DEBUG_LOG) {
                YungsCaveBiomesCommon.LOGGER.info("Force syncing sandstorm...");
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128379_("isSandstormActive", this.isSandstormActive);
        compoundTag.m_128356_("sandstormSeed", this.sandstormSeed);
        compoundTag.m_128405_("sandstormTime", this.currSandstormTicks);
        compoundTag.m_128405_("sandstormCooldown", this.cooldownTicks);
        compoundTag.m_128405_("totalSandstormDuration", this.totalSandstormDurationTicks);
        compoundTag.m_128405_("totalSandstormCooldown", this.totalSandstormCooldownTicks);
        return compoundTag;
    }

    private void resetSandstormTimeAndTotalDuration() {
        this.currSandstormTicks = this.totalSandstormDurationTicks = Mth.m_144928_((Random)this.serverLevel.m_5822_(), (int)YungsCaveBiomesCommon.CONFIG.lostCaves.minSandstormDuration, (int)YungsCaveBiomesCommon.CONFIG.lostCaves.maxSandstormDuration) * 20;
    }

    private void resetSandstormCooldownAndTotalCoolDown() {
        this.cooldownTicks = this.totalSandstormCooldownTicks = Mth.m_144928_((Random)this.serverLevel.m_5822_(), (int)YungsCaveBiomesCommon.CONFIG.lostCaves.minTimeBetweenSandstorms, (int)YungsCaveBiomesCommon.CONFIG.lostCaves.maxTimeBetweenSandstorms) * 20;
    }

    private void syncToClients() {
        Services.PLATFORM.syncSandstormDataToClients(this);
        this.timeSinceSync = 0;
        this.m_77762_();
    }

    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    public boolean isSandstormActive() {
        return this.isSandstormActive;
    }

    public int getCurrSandstormTicks() {
        return this.currSandstormTicks;
    }

    public long getSeed() {
        return this.sandstormSeed;
    }

    public int getTotalSandstormDurationTicks() {
        return this.totalSandstormDurationTicks;
    }
}

