/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.IceSheetConfiguration;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;

public class IceSheetFeature
extends Feature<IceSheetConfiguration> {
    private static final Set<Block> invalid_blocks = Set.of(Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_);
    private static final Set<Material> valid_materials = Set.of(Material.f_76314_, Material.f_76278_, Material.f_76317_, Material.f_76313_, Material.f_76315_);

    public IceSheetFeature(Codec<IceSheetConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<IceSheetConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        BlockPos originPos = featurePlaceContext.m_159777_();
        IceSheetConfiguration config = (IceSheetConfiguration)featurePlaceContext.m_159778_();
        int radius = config.searchRange;
        BlockPos.MutableBlockPos currPos = originPos.m_122032_();
        BlockPos.MutableBlockPos mutable = currPos.m_122032_();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dx = (double)x / (double)radius;
                    double dy = (double)y / (double)radius;
                    double dz = (double)z / (double)radius;
                    if (dx * dx + dy * dy + dz * dz > 1.0) continue;
                    currPos.m_122154_((Vec3i)originPos, x, y, z);
                    BlockState currState = worldGenLevel.m_8055_((BlockPos)currPos);
                    if (!IceSheetFeature.isAirOrWater(currState)) continue;
                    for (Direction direction : config.validDirections) {
                        IceSheetBlock iceSheetBlock;
                        BlockState updatedBlockState;
                        mutable.m_122159_((Vec3i)currPos, direction);
                        BlockState neighborBlockState = worldGenLevel.m_8055_((BlockPos)mutable);
                        if (invalid_blocks.contains(neighborBlockState.m_60734_()) || !valid_materials.contains(neighborBlockState.m_60767_()) || (updatedBlockState = (iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get())).m_153940_(currState, (BlockGetter)worldGenLevel, (BlockPos)currPos, direction)) == null) continue;
                        currState = updatedBlockState = (BlockState)updatedBlockState.m_61124_((Property)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(3));
                        worldGenLevel.m_7731_((BlockPos)currPos, updatedBlockState, 3);
                        worldGenLevel.m_46865_((BlockPos)currPos).m_8113_((BlockPos)currPos);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isAirOrWater(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_);
    }
}

