/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class IcicleClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public IcicleClusterFeature(Codec<DripstoneClusterConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<DripstoneClusterConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.m_159774_();
        BlockPos origin = featurePlaceContext.m_159777_();
        DripstoneClusterConfiguration config = (DripstoneClusterConfiguration)featurePlaceContext.m_159778_();
        Random random = featurePlaceContext.m_159776_();
        if (!DripstoneIceUtils.isEmpty((LevelAccessor)worldGenLevel, origin)) {
            return false;
        }
        int height = config.f_160760_.m_142270_(random);
        float wetness = config.f_160766_.m_142269_(random);
        float density = config.f_160765_.m_142269_(random);
        int uRadius = config.f_160761_.m_142270_(random);
        int vRadius = config.f_160761_.m_142270_(random);
        int uvRadiusMax = Math.max(uRadius, vRadius);
        float angle = random.nextFloat((float)Math.PI * 2);
        float rx = Mth.m_14089_((float)angle);
        float rz = Mth.m_14031_((float)angle);
        float ux = rx / (float)uRadius;
        float uz = rz / (float)uRadius;
        float vx = rz / (float)vRadius;
        float vz = -rx / (float)vRadius;
        for (int xOffset = -uvRadiusMax; xOffset <= uvRadiusMax; ++xOffset) {
            for (int zOffset = -uvRadiusMax; zOffset <= uvRadiusMax; ++zOffset) {
                float ellipseDensity = Mth.m_14207_((float)((float)xOffset * ux + (float)zOffset * uz)) + Mth.m_14207_((float)((float)xOffset * vx + (float)zOffset * vz));
                if (ellipseDensity >= 1.0f) continue;
                float chanceOfStalagmiteOrStalactite = this.getChanceOfStalagmiteOrStalactite(ellipseDensity, uvRadiusMax, config);
                BlockPos blockPos2 = origin.m_142082_(xOffset, 0, zOffset);
                this.placeColumn(worldGenLevel, random, blockPos2, xOffset, zOffset, wetness, chanceOfStalagmiteOrStalactite, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel worldGenLevel, Random random, BlockPos blockPos, int xOffset, int zOffset, float wetness, double chance, int height, float density, DripstoneClusterConfiguration config) {
        Optional columnOptional = Column.m_158175_((LevelSimulatedReader)worldGenLevel, (BlockPos)blockPos, (int)config.f_160759_, DripstoneUtils::m_159664_, DripstoneUtils::m_159649_);
        if (columnOptional.isEmpty()) {
            return;
        }
        OptionalInt ceilingOptional = ((Column)columnOptional.get()).m_142011_();
        OptionalInt floorOptional = ((Column)columnOptional.get()).m_142009_();
        if (ceilingOptional.isPresent() || floorOptional.isPresent()) {
            boolean q;
            int w;
            int p;
            int m;
            boolean n;
            int o;
            boolean bl2;
            Column column;
            boolean isWet;
            boolean bl = isWet = random.nextFloat() < wetness;
            if (isWet && floorOptional.isPresent() && this.canPlacePool(worldGenLevel, blockPos.m_175288_(floorOptional.getAsInt()))) {
                int floor = floorOptional.getAsInt();
                column = ((Column)columnOptional.get()).m_158181_(OptionalInt.of(floor - 1));
                worldGenLevel.m_7731_(blockPos.m_175288_(floor), Blocks.f_49990_.m_49966_(), 2);
            } else {
                column = (Column)columnOptional.get();
            }
            OptionalInt adjustedFloorOptional = column.m_142009_();
            boolean bl3 = bl2 = random.nextDouble() < chance;
            if (ceilingOptional.isPresent() && bl2 && !this.isLava((LevelReader)worldGenLevel, blockPos.m_175288_(ceilingOptional.getAsInt()))) {
                int thickness = config.f_160764_.m_142270_(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.m_175288_(ceilingOptional.getAsInt()), thickness, Direction.UP);
                int n2 = adjustedFloorOptional.isPresent() ? Math.min(height, ceilingOptional.getAsInt() - adjustedFloorOptional.getAsInt()) : height;
                o = this.getDripstoneHeight(random, xOffset, zOffset, density, n2, config);
            } else {
                o = 0;
            }
            boolean bl4 = n = random.nextDouble() < chance;
            if (adjustedFloorOptional.isPresent() && n && !this.isLava((LevelReader)worldGenLevel, blockPos.m_175288_(adjustedFloorOptional.getAsInt()))) {
                int thickness = config.f_160764_.m_142270_(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.m_175288_(adjustedFloorOptional.getAsInt()), thickness, Direction.DOWN);
                m = ceilingOptional.isPresent() ? Math.max(0, o + Mth.m_144928_((Random)random, (int)(-config.f_160762_), (int)config.f_160762_)) : this.getDripstoneHeight(random, xOffset, zOffset, density, height, config);
            } else {
                m = 0;
            }
            if (ceilingOptional.isPresent() && adjustedFloorOptional.isPresent() && ceilingOptional.getAsInt() - o <= adjustedFloorOptional.getAsInt() + m) {
                int adjustedFloor = adjustedFloorOptional.getAsInt();
                int adjustedCeiling = ceilingOptional.getAsInt();
                int s = Math.max(adjustedCeiling - o, adjustedFloor + 1);
                int t = Math.min(adjustedFloor + m, adjustedCeiling - 1);
                int u = Mth.m_144928_((Random)random, (int)s, (int)(t + 1));
                int v = u - 1;
                p = adjustedCeiling - u;
                w = v - adjustedFloor;
            } else {
                p = o;
                w = m;
            }
            boolean bl5 = q = random.nextBoolean() && p > 0 && w > 0 && column.m_142030_().isPresent() && p + w == column.m_142030_().getAsInt();
            if (ceilingOptional.isPresent()) {
                DripstoneIceUtils.growIcicle((LevelAccessor)worldGenLevel, blockPos.m_175288_(ceilingOptional.getAsInt() - 1), Direction.DOWN, p, q);
            }
        }
    }

    private boolean isLava(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos).m_60713_(Blocks.f_49991_);
    }

    private int getDripstoneHeight(Random random, int xOffset, int zOffset, float density, int height, DripstoneClusterConfiguration config) {
        if (random.nextFloat() > density) {
            return 0;
        }
        int l = Math.abs(xOffset) + Math.abs(zOffset);
        float g = (float)Mth.m_144851_((double)l, (double)0.0, (double)config.f_160769_, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.randomBetweenBiased(random, 0.0f, height, g, config.f_160763_);
    }

    private boolean canPlacePool(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        BlockState blockState = worldGenLevel.m_8055_(blockPos);
        if (!(blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_152537_) || blockState.m_60713_(Blocks.f_152588_))) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)worldGenLevel, blockPos.m_142300_(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)worldGenLevel, blockPos.m_7495_());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockState blockState = levelAccessor.m_8055_(blockPos);
        return blockState.m_204336_(BlockTags.f_13061_) || blockState.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private void replaceBlocksWithPackedIce(WorldGenLevel worldGenLevel, BlockPos blockPos, int length, Direction direction) {
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
        for (int i = 0; i < length; ++i) {
            if (!DripstoneIceUtils.placePackedIceIfPossible((LevelAccessor)worldGenLevel, (BlockPos)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.m_122173_(direction);
        }
    }

    private float getChanceOfStalagmiteOrStalactite(float ellipseDensity, float uvRadiusMax, DripstoneClusterConfiguration config) {
        return Mth.m_184631_((float)(ellipseDensity * (uvRadiusMax * uvRadiusMax)), (float)(uvRadiusMax * uvRadiusMax), (float)config.f_160768_, (float)config.f_160767_, (float)1.0f);
    }

    private static float randomBetweenBiased(Random random, float f, float g, float h, float i) {
        return ClampedNormalFloat.m_146434_((Random)random, (float)h, (float)i, (float)f, (float)g);
    }
}

