/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.CellularNoise;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WaterSurfaceIceFragmentFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int MIN_MAX_FLOOD_RADIUS = 8;
    private static final int MAX_MAX_FLOOD_RADIUS = 12;
    private static final int EFFECTIVE_MAX_FLOOD_RADIUS = 11;
    private static final int EFFECTIVE_MAX_FLOOD_DIAMETER = 23;
    private static final int MAX_FLOOD_RADIUS_RANGE = 4;
    private static final float FLOOD_BOUNDARY_NOISE_FREQUENCY = 0.1f;
    private static final long FLOOD_BOUNDARY_NOISE_SEED_FLIP = -3496757360140900525L;
    private static final float ICE_FRAGMENT_SEPARATION = 0.15f;
    private static final float ICE_FRAGMENT_NOISE_FREQUENCY = 0.083333336f;
    private static final float DOMAIN_WARP_FREQUENCY = 0.083333336f;
    private static final float DOMAIN_WARP_AMPLITUDE = 4.0f;
    private static final long WARP_NOISE_SEED_FLIP = 3811143571666535007L;
    private static final long CELL_NOISE_SEED_FLIP = 6534415494888897672L;
    private static final ThreadLocal<IceFragmentFiller> iceFragmentFillerThreadLocal = ThreadLocal.withInitial(IceFragmentFiller::new);

    public WaterSurfaceIceFragmentFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        iceFragmentFillerThreadLocal.get().execute(origin, level);
        return false;
    }

    private static class IceFragmentFiller {
        private final Queue<BlockPos> floodQueue = new ArrayDeque<BlockPos>(529);
        private final boolean[] visited = new boolean[529];
        private final Vector3f domainWarpVector = new Vector3f();

        public void execute(BlockPos origin, WorldGenLevel level) {
            long seed = level.m_7328_();
            long noiseSeedWarp = seed ^ 0x34E3E6E2D932825FL;
            long noiseSeedCell = seed ^ 0x5AAEE84593A93C88L;
            long noiseSeedFlood = seed ^ 0xCF7905B52311A753L;
            this.floodQueue.clear();
            Arrays.fill(this.visited, false);
            this.floodQueue.add(origin);
            while (!this.floodQueue.isEmpty()) {
                BlockPos currentPos = this.floodQueue.poll();
                BlockState currentState = level.m_8055_(currentPos);
                if (!currentState.m_60713_(Blocks.f_49990_) && !currentState.m_60713_(Blocks.f_50126_)) continue;
                OpenSimplex2S.vec3Noise3_ImproveXZ(noiseSeedWarp, (float)currentPos.m_123341_() * 0.083333336f, (float)currentPos.m_123342_() * 0.083333336f, (float)currentPos.m_123343_() * 0.083333336f, this.domainWarpVector);
                float iceShardNoiseValue = CellularNoise.sampleDistance2Sub_ImproveXZ(noiseSeedCell, (float)currentPos.m_123341_() * 0.083333336f + this.domainWarpVector.m_122239_() * 0.33333334f, (float)currentPos.m_123342_() * 0.083333336f + this.domainWarpVector.m_122260_() * 0.33333334f, (float)currentPos.m_123343_() * 0.083333336f + this.domainWarpVector.m_122269_() * 0.33333334f);
                if (iceShardNoiseValue <= 0.15f) continue;
                level.m_7731_(currentPos, Blocks.f_50126_.m_49966_(), 2);
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.m_142126_());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.m_142125_());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.m_142128_());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.m_142127_());
            }
        }

        private void considerNeighbor(long noiseSeedFlood, BlockPos origin, BlockPos neighborPos) {
            float noiseValue;
            float noisyRadius;
            int dx = neighborPos.m_123341_() - origin.m_123341_();
            int dz = neighborPos.m_123343_() - origin.m_123343_();
            if (dx < -11 || dx > 11 || dz < -11 || dz > 11) {
                return;
            }
            int visitedIndex = (dz + 11) * 23 + (dx + 11);
            if (this.visited[visitedIndex]) {
                return;
            }
            this.visited[visitedIndex] = true;
            float distSq = dx * dx + dz * dz;
            if (distSq > 121.0f) {
                return;
            }
            if (distSq > 64.0f && distSq > (noisyRadius = (noiseValue = OpenSimplex2S.noise3_ImproveXZ(noiseSeedFlood, (float)(origin.m_123341_() + dx) * 0.1f, (float)origin.m_123342_() * 0.1f, (float)(origin.m_123343_() + dz) * 0.1f)) * 2.0f + 10.0f) * noisyRadius) {
                return;
            }
            this.floodQueue.add(neighborPos);
        }
    }
}

