/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.kjscc;

import com.prunoideae.kjscc.PeripheralMethod;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.ScriptableObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicPeripheralJS
implements IDynamicPeripheral {
    protected final String[] names;
    protected final PeripheralMethod[] methods;
    protected final BlockContainerJS block;
    protected final Direction side;
    protected final String type;

    public DynamicPeripheralJS(String type, Level world, BlockPos pos, Direction side, List<PeripheralMethod> nameMethods) {
        this.block = new BlockContainerJS(world, pos);
        this.side = side;
        this.type = type;
        ArrayList names = new ArrayList();
        nameMethods.forEach(pair -> names.add(pair.type()));
        this.names = (String[])names.toArray(String[]::new);
        this.methods = (PeripheralMethod[])nameMethods.toArray(PeripheralMethod[]::new);
    }

    @NotNull
    public String[] getMethodNames() {
        return this.names;
    }

    @NotNull
    public final MethodResult callMethod(@NotNull IComputerAccess computer, @NotNull ILuaContext context, int method, @NotNull IArguments arguments) throws LuaException {
        try {
            PeripheralMethod peripheralMethod = this.methods[method];
            if (peripheralMethod.mainThread()) {
                return context.executeMainThreadTask(() -> new Object[]{peripheralMethod.callback().call(this.block, this.side, arguments, computer, context)});
            }
            return MethodResult.of((Object)DynamicPeripheralJS.jsToLuaType(peripheralMethod.callback().call(this.block, this.side, arguments, computer, context)));
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    private static Object jsToLuaType(Object o) {
        if (o instanceof ScriptableObject) {
            ScriptableObject scriptableObject = (ScriptableObject)o;
            if (o instanceof NativeArray) {
                NativeArray array = (NativeArray)o;
                return array.stream().map(DynamicPeripheralJS::jsToLuaType).toArray();
            }
            HashMap<Object, Object> table = new HashMap<Object, Object>();
            for (Object key : scriptableObject.getIds()) {
                table.put(key, DynamicPeripheralJS.jsToLuaType(scriptableObject.get(key)));
            }
            return table;
        }
        return o;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof DynamicPeripheralJS)) return false;
        DynamicPeripheralJS peripheralJS = (DynamicPeripheralJS)other;
        if (!peripheralJS.type.equals(this.type)) return false;
        if (!peripheralJS.block.equals((Object)this.block)) return false;
        return true;
    }

    @FunctionalInterface
    public static interface PeripheralCallback {
        public Object call(BlockContainerJS var1, Direction var2, IArguments var3, IComputerAccess var4, ILuaContext var5);
    }
}

