/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.sync.ContraptionFluidPacket;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;

public class MountedFluidStorage {
    SmartFluidTank tank;
    private boolean valid;
    private BlockEntity blockEntity;
    private int packetCooldown = 0;
    private boolean sendPacket = false;

    public static boolean canUseAsStorage(BlockEntity be) {
        if (be instanceof FluidTankBlockEntity) {
            return ((FluidTankBlockEntity)be).isController();
        }
        return false;
    }

    public MountedFluidStorage(BlockEntity be) {
        this.assignBlockEntity(be);
    }

    public void assignBlockEntity(BlockEntity be) {
        this.blockEntity = be;
        this.tank = this.createMountedTank(be);
    }

    private SmartFluidTank createMountedTank(BlockEntity be) {
        if (be instanceof CreativeFluidTankBlockEntity) {
            return new CreativeFluidTankBlockEntity.CreativeSmartFluidTank(((FluidTankBlockEntity)be).getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier(), $ -> {});
        }
        if (be instanceof FluidTankBlockEntity) {
            return new SmartFluidTank(((FluidTankBlockEntity)be).getTotalTankSize() * FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
        }
        return null;
    }

    public void tick(Entity entity, BlockPos pos, boolean isRemote) {
        if (!isRemote) {
            if (this.packetCooldown > 0) {
                --this.packetCooldown;
            } else if (this.sendPacket) {
                this.sendPacket = false;
                AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ContraptionFluidPacket(entity.m_142049_(), pos, this.tank.getFluid()));
                this.packetCooldown = 8;
            }
            return;
        }
        if (!(this.blockEntity instanceof FluidTankBlockEntity)) {
            return;
        }
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.blockEntity;
        tank.getFluidLevel().tickChaser();
    }

    public void updateFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
        if (!(this.blockEntity instanceof FluidTankBlockEntity)) {
            return;
        }
        float fillState = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.blockEntity;
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue(fillState));
        }
        tank.getFluidLevel().chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        IFluidTank tankInventory = tank.getTankInventory();
        if (tankInventory instanceof SmartFluidTank) {
            ((SmartFluidTank)tankInventory).setFluid(fluid);
        }
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.blockEntity == null) {
            return;
        }
        IFluidHandler teHandler = (IFluidHandler)this.blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank smartTank = (SmartFluidTank)teHandler;
        this.tank.setFluid(smartTank.getFluid());
        this.sendPacket = false;
        this.valid = true;
    }

    private void onFluidStackChanged(FluidStack fs) {
        this.sendPacket = true;
    }

    public void addStorageToWorld(BlockEntity be) {
        if (this.tank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
            return;
        }
        LazyOptional capability = be.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler teHandler = (IFluidHandler)capability.orElse(null);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank inv = (SmartFluidTank)teHandler;
        inv.setFluid(this.tank.getFluid().copy());
    }

    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public CompoundTag serialize() {
        if (!this.valid) {
            return null;
        }
        CompoundTag tag = this.tank.writeToNBT(new CompoundTag());
        tag.m_128405_("Capacity", this.tank.getCapacity());
        if (this.tank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
            NBTHelper.putMarker(tag, "Bottomless");
            tag.m_128365_("ProvidedStack", (Tag)this.tank.getFluid().writeToNBT(new CompoundTag()));
        }
        return tag;
    }

    public static MountedFluidStorage deserialize(CompoundTag nbt) {
        MountedFluidStorage storage = new MountedFluidStorage(null);
        if (nbt == null) {
            return storage;
        }
        int capacity = nbt.m_128451_("Capacity");
        storage.tank = new SmartFluidTank(capacity, storage::onFluidStackChanged);
        storage.valid = true;
        if (nbt.m_128441_("Bottomless")) {
            FluidStack providedStack = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("ProvidedStack"));
            CreativeFluidTankBlockEntity.CreativeSmartFluidTank creativeSmartFluidTank = new CreativeFluidTankBlockEntity.CreativeSmartFluidTank(capacity, $ -> {});
            creativeSmartFluidTank.setContainedFluid(providedStack);
            storage.tank = creativeSmartFluidTank;
            return storage;
        }
        storage.tank.readFromNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }
}

